/*
 * Decompiled with CFR 0.152.
 */
package de.studiocode.invui.gui.structure;

import de.studiocode.invui.gui.SlotElement;
import de.studiocode.invui.gui.structure.Marker;
import java.util.function.Supplier;

class Ingredient {
    private final SlotElement slotElement;
    private final Marker marker;
    private final Supplier<? extends SlotElement> elementSupplier;

    public Ingredient(SlotElement slotElement) {
        this.slotElement = slotElement;
        this.elementSupplier = null;
        this.marker = null;
    }

    public Ingredient(Supplier<? extends SlotElement> elementSupplier) {
        this.elementSupplier = elementSupplier;
        this.slotElement = null;
        this.marker = null;
    }

    public Ingredient(Marker marker) {
        this.marker = marker;
        this.slotElement = null;
        this.elementSupplier = null;
    }

    public SlotElement getSlotElement() {
        return this.slotElement == null ? this.elementSupplier.get() : this.slotElement;
    }

    public Marker getMarker() {
        return this.marker;
    }

    public boolean isSlotElement() {
        return this.slotElement != null || this.elementSupplier != null;
    }

    public boolean isMarker() {
        return this.marker != null;
    }
}

