/*
 * Decompiled with CFR 0.152.
 */
package de.studiocode.invui.gui.impl;

import de.studiocode.invui.gui.GUI;
import de.studiocode.invui.gui.SlotElement;
import de.studiocode.invui.gui.impl.TabGUI;
import de.studiocode.invui.gui.structure.Structure;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleTabGUI
extends TabGUI {
    private final List<GUI> tabs;
    private final List<List<SlotElement>> linkingElements;
    private List<BiConsumer<Integer, Integer>> tabChangeHandlers;

    public SimpleTabGUI(int width, int height, @NotNull List<GUI> tabs, int[] listSlots) {
        super(width, height, tabs.size(), listSlots);
        this.linkingElements = tabs.stream().map(this::getLinkingElements).collect(Collectors.toList());
        this.tabs = tabs;
        this.update();
    }

    public SimpleTabGUI(@NotNull List<GUI> tabs, @NotNull Structure structure) {
        super(structure.getWidth(), structure.getHeight(), tabs.size(), structure);
        this.linkingElements = tabs.stream().map(this::getLinkingElements).collect(Collectors.toList());
        this.tabs = tabs;
        this.update();
    }

    private List<SlotElement> getLinkingElements(GUI gui) {
        if (gui == null) {
            return null;
        }
        ArrayList<SlotElement> elements = new ArrayList<SlotElement>();
        for (int slot = 0; slot < gui.getSize(); ++slot) {
            SlotElement.LinkedSlotElement link = new SlotElement.LinkedSlotElement(gui, slot);
            elements.add(link);
        }
        return elements;
    }

    public List<GUI> getTabs() {
        return Collections.unmodifiableList(this.tabs);
    }

    @Override
    public boolean isTabAvailable(int tab) {
        return this.tabs.get(tab) != null;
    }

    public void addTabChangeHandler(@NotNull BiConsumer<Integer, Integer> tabChangeHandler) {
        if (this.tabChangeHandlers == null) {
            this.tabChangeHandlers = new ArrayList<BiConsumer<Integer, Integer>>();
        }
        this.tabChangeHandlers.add(tabChangeHandler);
    }

    public void removeTabChangeHandler(@NotNull BiConsumer<Integer, Integer> tabChangeHandler) {
        if (this.tabChangeHandlers != null) {
            this.tabChangeHandlers.remove(tabChangeHandler);
        }
    }

    @Nullable
    public List<BiConsumer<Integer, Integer>> getTabChangeHandlers() {
        return this.tabChangeHandlers;
    }

    public void setTabChangeHandlers(@Nullable List<BiConsumer<Integer, Integer>> tabChangeHandlers) {
        this.tabChangeHandlers = tabChangeHandlers;
    }

    @Override
    protected void handleTabChange(int previous, int now) {
        if (this.tabChangeHandlers != null) {
            this.tabChangeHandlers.forEach(handler -> handler.accept(previous, now));
        }
    }

    @Override
    protected List<SlotElement> getSlotElements(int tab) {
        return this.linkingElements.get(tab);
    }
}

