/*
 * Decompiled with CFR 0.152.
 */
package de.studiocode.invui.gui.impl;

import de.studiocode.invui.gui.SlotElement;
import de.studiocode.invui.gui.impl.ScrollGUI;
import de.studiocode.invui.gui.structure.Structure;
import de.studiocode.invui.virtualinventory.VirtualInventory;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleScrollVIGUI
extends ScrollGUI {
    private VirtualInventory inventory;

    public SimpleScrollVIGUI(int width, int height, @Nullable VirtualInventory inventory, int ... itemListSlots) {
        super(width, height, false, itemListSlots);
        this.inventory = inventory;
        this.update();
    }

    public SimpleScrollVIGUI(@Nullable VirtualInventory inventory, @NotNull Structure structure) {
        super(structure.getWidth(), structure.getHeight(), false, structure);
        this.inventory = inventory;
        this.update();
    }

    public void setInventory(VirtualInventory inventory) {
        this.inventory = inventory;
        this.update();
    }

    protected List<SlotElement.VISlotElement> getElements(int from, int to) {
        ArrayList<SlotElement.VISlotElement> elements = new ArrayList<SlotElement.VISlotElement>();
        if (this.inventory != null) {
            for (int i = from; i < to && i < this.inventory.getSize(); ++i) {
                elements.add(new SlotElement.VISlotElement(this.inventory, i));
            }
        }
        return elements;
    }

    @Override
    protected int getMaxLineIndex() {
        if (this.inventory == null) {
            return 0;
        }
        return (int)Math.ceil((double)this.inventory.getSize() / (double)this.getLineLength()) - 1;
    }
}

