/*
 * Decompiled with CFR 0.152.
 */
package de.studiocode.invui.gui.impl;

import de.studiocode.invui.gui.GUI;
import de.studiocode.invui.gui.SlotElement;
import de.studiocode.invui.gui.impl.ScrollGUI;
import de.studiocode.invui.gui.structure.Structure;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleScrollNestedGUI
extends ScrollGUI {
    private List<GUI> guis;
    private List<SlotElement.LinkedSlotElement> elements;

    public SimpleScrollNestedGUI(int width, int height, @Nullable List<GUI> guis, int ... itemListSlots) {
        super(width, height, false, itemListSlots);
        this.setGuis(guis);
    }

    public SimpleScrollNestedGUI(@Nullable List<GUI> guis, @NotNull Structure structure) {
        super(structure.getWidth(), structure.getHeight(), false, structure);
        this.setGuis(guis);
    }

    public void setGuis(@Nullable List<GUI> guis) {
        this.guis = guis != null ? guis : new ArrayList();
        this.updateElements();
        this.update();
    }

    private void updateElements() {
        this.elements = new ArrayList<SlotElement.LinkedSlotElement>();
        for (GUI gui : this.guis) {
            for (int i = 0; i < gui.getSize(); ++i) {
                this.elements.add(new SlotElement.LinkedSlotElement(gui, i));
            }
        }
    }

    protected List<SlotElement.LinkedSlotElement> getElements(int from, int to) {
        return this.elements.subList(from, Math.min(this.elements.size(), to));
    }

    @Override
    protected int getMaxLineIndex() {
        return this.guis.size() - 1;
    }
}

