/*
 * Decompiled with CFR 0.152.
 */
package de.studiocode.invui.gui.impl;

import de.studiocode.invui.gui.SlotElement;
import de.studiocode.invui.gui.impl.ScrollGUI;
import de.studiocode.invui.gui.structure.Structure;
import de.studiocode.invui.item.Item;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleScrollItemsGUI
extends ScrollGUI {
    private List<Item> items;

    public SimpleScrollItemsGUI(int width, int height, @Nullable List<Item> items, int ... itemListSlots) {
        super(width, height, false, itemListSlots);
        this.setItems(items);
    }

    public SimpleScrollItemsGUI(@Nullable List<Item> items, @NotNull Structure structure) {
        super(structure.getWidth(), structure.getHeight(), false, structure);
        this.setItems(items);
    }

    public void setItems(@Nullable List<Item> items) {
        this.items = items != null ? items : new ArrayList();
        this.update();
    }

    protected List<SlotElement> getElements(int from, int to) {
        return this.items.subList(from, Math.min(this.items.size(), to)).stream().map(SlotElement.ItemSlotElement::new).collect(Collectors.toList());
    }

    @Override
    protected int getMaxLineIndex() {
        return (int)Math.ceil((double)this.items.size() / (double)this.getLineLength()) - 1;
    }
}

