/*
 * Decompiled with CFR 0.152.
 */
package de.studiocode.invui.gui.impl;

import de.studiocode.invui.gui.GUI;
import de.studiocode.invui.gui.SlotElement;
import de.studiocode.invui.gui.impl.PagedGUI;
import de.studiocode.invui.gui.structure.Structure;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimplePagedNestedGUI
extends PagedGUI {
    private List<GUI> guis;
    private List<BiConsumer<Integer, Integer>> pageChangeHandlers;

    public SimplePagedNestedGUI(int width, int height, @Nullable List<GUI> guis, int ... itemListSlots) {
        super(width, height, false, itemListSlots);
        this.setGuis(guis);
    }

    public SimplePagedNestedGUI(@Nullable List<GUI> guis, @NotNull Structure structure) {
        super(structure.getWidth(), structure.getHeight(), false, structure);
        this.setGuis(guis);
    }

    @Override
    public int getPageAmount() {
        return this.guis.size();
    }

    public void setGuis(@Nullable List<GUI> guis) {
        this.guis = guis == null ? new ArrayList() : guis;
        this.update();
    }

    public void addPageChangeHandler(@NotNull BiConsumer<Integer, Integer> pageChangeHandler) {
        if (this.pageChangeHandlers == null) {
            this.pageChangeHandlers = new ArrayList<BiConsumer<Integer, Integer>>();
        }
        this.pageChangeHandlers.add(pageChangeHandler);
    }

    public void removePageChangeHandler(@NotNull BiConsumer<Integer, Integer> pageChangeHandler) {
        if (this.pageChangeHandlers != null) {
            this.pageChangeHandlers.remove(pageChangeHandler);
        }
    }

    @Nullable
    public List<BiConsumer<Integer, Integer>> getPageChangeHandlers() {
        return this.pageChangeHandlers;
    }

    public void setPageChangeHandlers(@Nullable List<BiConsumer<Integer, Integer>> pageChangeHandlers) {
        this.pageChangeHandlers = pageChangeHandlers;
    }

    @Override
    protected void handlePageChange(int previous, int now) {
        if (this.pageChangeHandlers != null) {
            this.pageChangeHandlers.forEach(handler -> handler.accept(previous, now));
        }
    }

    @Override
    protected List<SlotElement> getPageElements(int page) {
        if (this.guis.size() <= page) {
            return new ArrayList<SlotElement>();
        }
        GUI gui = this.guis.get(page);
        int size = gui.getSize();
        return IntStream.range(0, size).mapToObj(i -> new SlotElement.LinkedSlotElement(gui, i)).collect(Collectors.toList());
    }
}

