/*
 * Decompiled with CFR 0.152.
 */
package de.studiocode.invui.gui.impl;

import de.studiocode.invui.gui.SlotElement;
import de.studiocode.invui.gui.impl.BaseGUI;
import de.studiocode.invui.gui.structure.Structure;
import java.util.List;

public abstract class PagedGUI
extends BaseGUI {
    private final boolean infinitePages;
    private final int[] itemListSlots;
    private int currentPage;

    public PagedGUI(int width, int height, boolean infinitePages, int ... itemListSlots) {
        super(width, height);
        this.infinitePages = infinitePages;
        this.itemListSlots = itemListSlots;
    }

    public PagedGUI(int width, int height, boolean infinitePages, Structure structure) {
        this(width, height, infinitePages, structure.getIngredientList().findItemListSlots());
        this.applyStructure(structure);
    }

    public void goForward() {
        if (this.hasNextPage()) {
            this.setPage(this.currentPage + 1);
        }
    }

    public void goBack() {
        if (this.hasPageBefore()) {
            this.setPage(this.currentPage - 1);
        }
    }

    public void setPage(int page) {
        int previous = this.currentPage;
        this.currentPage = page;
        this.update();
        if (previous != this.currentPage) {
            this.handlePageChange(previous, this.currentPage);
        }
    }

    public boolean hasNextPage() {
        return this.currentPage < this.getPageAmount() - 1 || this.infinitePages;
    }

    public boolean hasPageBefore() {
        return this.currentPage > 0;
    }

    protected void update() {
        this.correctPage();
        this.updateControlItems();
        this.updatePageContent();
    }

    private void correctPage() {
        if (this.currentPage == 0 || this.infinitePages) {
            return;
        }
        int pageAmount = this.getPageAmount();
        if (this.currentPage < 0 || pageAmount <= 0) {
            this.currentPage = 0;
        } else if (this.currentPage >= pageAmount) {
            this.currentPage = pageAmount - 1;
        }
    }

    private void updatePageContent() {
        List<SlotElement> slotElements = this.getPageElements(this.currentPage);
        for (int i = 0; i < this.itemListSlots.length; ++i) {
            if (slotElements.size() > i) {
                this.setSlotElement(this.itemListSlots[i], slotElements.get(i));
                continue;
            }
            this.remove(this.itemListSlots[i]);
        }
    }

    public int getCurrentPageIndex() {
        return this.currentPage;
    }

    public boolean hasInfinitePages() {
        return this.infinitePages;
    }

    public int[] getItemListSlots() {
        return this.itemListSlots;
    }

    public abstract int getPageAmount();

    protected abstract List<SlotElement> getPageElements(int var1);

    protected abstract void handlePageChange(int var1, int var2);
}

