/*
 * Decompiled with CFR 0.152.
 */
package de.studiocode.invui.gui.builder;

import de.studiocode.invui.gui.GUI;
import de.studiocode.invui.gui.SlotElement;
import de.studiocode.invui.gui.builder.GUIContext;
import de.studiocode.invui.gui.builder.guitype.GUIType;
import de.studiocode.invui.gui.structure.Marker;
import de.studiocode.invui.gui.structure.Structure;
import de.studiocode.invui.item.Item;
import de.studiocode.invui.item.ItemProvider;
import de.studiocode.invui.virtualinventory.VirtualInventory;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GUIBuilder<G extends GUI> {
    private final GUIType<G> guiType;
    private final GUIContext context;

    public GUIBuilder(@NotNull GUIType<G> guiType) {
        this.guiType = guiType;
        this.context = new GUIContext();
    }

    public GUIBuilder<G> setStructure(int width, int height, @NotNull String structureData) {
        this.context.setStructure(new Structure(width, height, structureData));
        return this;
    }

    public GUIBuilder<G> setStructure(String ... structureData) {
        return this.setStructure(new Structure(structureData));
    }

    public GUIBuilder<G> setStructure(@NotNull Structure structure) {
        this.context.setStructure(structure);
        return this;
    }

    public GUIBuilder<G> addIngredient(char key, @NotNull ItemStack itemStack) {
        this.context.getStructure().addIngredient(key, itemStack);
        return this;
    }

    public GUIBuilder<G> addIngredient(char key, @NotNull ItemProvider itemProvider) {
        this.context.getStructure().addIngredient(key, itemProvider);
        return this;
    }

    public GUIBuilder<G> addIngredient(char key, @NotNull Item item) {
        this.context.getStructure().addIngredient(key, item);
        return this;
    }

    public GUIBuilder<G> addIngredient(char key, @NotNull VirtualInventory inventory) {
        this.context.getStructure().addIngredient(key, inventory);
        return this;
    }

    public GUIBuilder<G> addIngredient(char key, @NotNull VirtualInventory inventory, @Nullable ItemProvider background) {
        this.context.getStructure().addIngredient(key, inventory, background);
        return this;
    }

    public GUIBuilder<G> addIngredient(char key, @NotNull SlotElement element) {
        this.context.getStructure().addIngredient(key, element);
        return this;
    }

    public GUIBuilder<G> addIngredient(char key, @NotNull Marker marker) {
        this.context.getStructure().addIngredient(key, marker);
        return this;
    }

    public GUIBuilder<G> addIngredient(char key, @NotNull Supplier<? extends Item> itemSupplier) {
        this.context.getStructure().addIngredient(key, itemSupplier);
        return this;
    }

    public GUIBuilder<G> addIngredientElementSupplier(char key, @NotNull Supplier<? extends SlotElement> elementSupplier) {
        this.context.getStructure().addIngredientElementSupplier(key, elementSupplier);
        return this;
    }

    public GUIBuilder<G> setItems(@NotNull List<Item> items) {
        if (!this.guiType.acceptsItems()) {
            throw new UnsupportedOperationException("Items cannot be set in this gui type.");
        }
        this.context.setItems(items);
        return this;
    }

    public GUIBuilder<G> addItem(@NotNull Item item) {
        if (!this.guiType.acceptsItems()) {
            throw new UnsupportedOperationException("Items cannot be set in this gui type.");
        }
        if (this.context.getItems() == null) {
            this.context.setItems(new ArrayList<Item>());
        }
        this.context.getItems().add(item);
        return this;
    }

    public GUIBuilder<G> setGUIs(@NotNull List<GUI> guis) {
        if (!this.guiType.acceptsGUIs()) {
            throw new UnsupportedOperationException("GUIs cannot be set in this gui type.");
        }
        this.context.setGuis(guis);
        return this;
    }

    public GUIBuilder<G> addGUI(@NotNull GUI gui) {
        if (!this.guiType.acceptsGUIs()) {
            throw new UnsupportedOperationException("GUIs cannot be set in this gui type.");
        }
        if (this.context.getGuis() == null) {
            this.context.setGuis(new ArrayList<GUI>());
        }
        this.context.getGuis().add(gui);
        return this;
    }

    public GUIBuilder<G> setInventory(@NotNull VirtualInventory inventory) {
        if (!this.guiType.acceptsInventory()) {
            throw new UnsupportedOperationException("An inventory cannot be set in this gui type.");
        }
        this.context.setInventory(inventory);
        return this;
    }

    public GUIBuilder<G> setBackground(@Nullable ItemProvider background) {
        this.context.setBackground(background);
        return this;
    }

    public G build() {
        if (this.context.getStructure() == null) {
            throw new IllegalStateException("GUIContext has not been set yet.");
        }
        return this.guiType.createGUI(this.context);
    }
}

