/*
 * Decompiled with CFR 0.152.
 */
package de.studiocode.invui.gui;

import de.studiocode.invui.gui.GUI;
import de.studiocode.invui.item.Item;
import de.studiocode.invui.item.ItemProvider;
import de.studiocode.invui.virtualinventory.VirtualInventory;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.inventory.ItemStack;

public interface SlotElement {
    public ItemStack getItemStack(UUID var1);

    public SlotElement getHoldingElement();

    public static class LinkedSlotElement
    implements SlotElement {
        private final GUI gui;
        private final int slot;

        public LinkedSlotElement(GUI gui, int slot) {
            this.gui = gui;
            this.slot = slot;
        }

        public GUI getGui() {
            return this.gui;
        }

        public int getSlotIndex() {
            return this.slot;
        }

        @Override
        public SlotElement getHoldingElement() {
            SlotElement below;
            LinkedSlotElement element = this;
            while ((below = element.getGui().getSlotElement(element.getSlotIndex())) instanceof LinkedSlotElement) {
                element = (LinkedSlotElement)below;
            }
            return below;
        }

        public List<GUI> getGuiList() {
            ArrayList<GUI> guis = new ArrayList<GUI>();
            LinkedSlotElement element = this;
            while (true) {
                guis.add(element.getGui());
                SlotElement below = element.getGui().getSlotElement(element.getSlotIndex());
                if (!(below instanceof LinkedSlotElement)) break;
                element = (LinkedSlotElement)below;
            }
            return guis;
        }

        @Override
        public ItemStack getItemStack(UUID viewerUUID) {
            SlotElement holdingElement = this.getHoldingElement();
            return holdingElement != null ? holdingElement.getItemStack(viewerUUID) : null;
        }
    }

    public static class VISlotElement
    implements SlotElement {
        private final VirtualInventory virtualInventory;
        private final int slot;
        private final ItemProvider background;

        public VISlotElement(VirtualInventory virtualInventory, int slot) {
            this.virtualInventory = virtualInventory;
            this.slot = slot;
            this.background = null;
        }

        public VISlotElement(VirtualInventory virtualInventory, int slot, ItemProvider background) {
            this.virtualInventory = virtualInventory;
            this.slot = slot;
            this.background = background;
        }

        public VirtualInventory getVirtualInventory() {
            return this.virtualInventory;
        }

        public int getSlot() {
            return this.slot;
        }

        public ItemProvider getBackground() {
            return this.background;
        }

        @Override
        public ItemStack getItemStack(UUID viewerUUID) {
            ItemStack itemStack = this.virtualInventory.getUnsafeItemStack(this.slot);
            if (itemStack == null && this.background != null) {
                itemStack = this.background.getFor(viewerUUID);
            }
            return itemStack;
        }

        @Override
        public SlotElement getHoldingElement() {
            return this;
        }
    }

    public static class ItemSlotElement
    implements SlotElement {
        private final Item item;

        public ItemSlotElement(Item item) {
            this.item = item;
        }

        public Item getItem() {
            return this.item;
        }

        @Override
        public ItemStack getItemStack(UUID viewerUUID) {
            return this.item.getItemProvider().getFor(viewerUUID);
        }

        @Override
        public SlotElement getHoldingElement() {
            return this;
        }
    }
}

