/*
 * Decompiled with CFR 0.152.
 */
package de.studiocode.invui;

import de.studiocode.inventoryaccess.util.ReflectionRegistry;
import de.studiocode.inventoryaccess.util.ReflectionUtils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class InvUI
implements Listener {
    private static InvUI instance;
    private final List<Runnable> disableHandlers = new ArrayList<Runnable>();
    private Plugin plugin;

    private InvUI() {
    }

    public static InvUI getInstance() {
        return instance == null ? (instance = new InvUI()) : instance;
    }

    @NotNull
    public Plugin getPlugin() {
        if (this.plugin == null) {
            this.plugin = (Plugin)ReflectionUtils.getFieldValue(ReflectionRegistry.PLUGIN_CLASS_LOADER_PLUGIN_FIELD, this.getClass().getClassLoader());
            Bukkit.getPluginManager().registerEvents((Listener)this, this.plugin);
        }
        return this.plugin;
    }

    public void setPlugin(@NotNull Plugin plugin) {
        if (this.plugin != null) {
            throw new IllegalStateException("Plugin is already set");
        }
        Bukkit.getPluginManager().registerEvents((Listener)this, plugin);
        this.plugin = plugin;
    }

    public void addDisableHandler(@NotNull Runnable runnable) {
        this.disableHandlers.add(runnable);
    }

    @EventHandler
    private void handlePluginDisable(PluginDisableEvent event) {
        if (event.getPlugin().equals(this.plugin)) {
            this.disableHandlers.forEach(Runnable::run);
        }
    }
}

