/*
 * Decompiled with CFR 0.152.
 */
package de.studiocode.inventoryaccess.version;

import de.studiocode.inventoryaccess.abstraction.inventory.AnvilInventory;
import de.studiocode.inventoryaccess.abstraction.inventory.CartographyInventory;
import de.studiocode.inventoryaccess.abstraction.util.InventoryUtils;
import de.studiocode.inventoryaccess.abstraction.util.ItemUtils;
import de.studiocode.inventoryaccess.abstraction.util.PlayerUtils;
import de.studiocode.inventoryaccess.component.ComponentWrapper;
import de.studiocode.inventoryaccess.util.ReflectionUtils;
import java.lang.reflect.Constructor;
import java.util.function.Consumer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class InventoryAccess {
    private static final Class<InventoryUtils> INVENTORY_UTILS_CLASS = ReflectionUtils.getImplClass("util.InventoryUtilsImpl");
    private static final Class<ItemUtils> ITEM_UTILS_CLASS = ReflectionUtils.getImplClass("util.ItemUtilsImpl");
    private static final Class<PlayerUtils> PLAYER_UTILS_CLASS = ReflectionUtils.getImplClass("util.PlayerUtilsImpl");
    private static final Class<AnvilInventory> ANVIL_INVENTORY_CLASS = ReflectionUtils.getImplClass("inventory.AnvilInventoryImpl");
    private static final Class<CartographyInventory> CARTOGRAPHY_INVENTORY_CLASS = ReflectionUtils.getImplClass("inventory.CartographyInventoryImpl");
    private static final Constructor<AnvilInventory> ANVIL_INVENTORY_CONSTRUCTOR = ReflectionUtils.getConstructor(ANVIL_INVENTORY_CLASS, false, Player.class, ComponentWrapper.class, Consumer.class);
    private static final Constructor<CartographyInventory> CARTOGRAPHY_INVENTORY_CONSTRUCTOR = ReflectionUtils.getConstructor(CARTOGRAPHY_INVENTORY_CLASS, false, Player.class, ComponentWrapper.class);
    private static final InventoryUtils INVENTORY_UTILS = (InventoryUtils)ReflectionUtils.constructEmpty(INVENTORY_UTILS_CLASS);
    private static final ItemUtils ITEM_UTILS = (ItemUtils)ReflectionUtils.constructEmpty(ITEM_UTILS_CLASS);
    private static final PlayerUtils PLAYER_UTILS = (PlayerUtils)ReflectionUtils.constructEmpty(PLAYER_UTILS_CLASS);

    public static InventoryUtils getInventoryUtils() {
        return INVENTORY_UTILS;
    }

    public static ItemUtils getItemUtils() {
        return ITEM_UTILS;
    }

    public static PlayerUtils getPlayerUtils() {
        return PLAYER_UTILS;
    }

    public static AnvilInventory createAnvilInventory(@NotNull Player player, @NotNull ComponentWrapper title, Consumer<String> renameHandler) {
        return ReflectionUtils.construct(ANVIL_INVENTORY_CONSTRUCTOR, player, title, renameHandler);
    }

    public static CartographyInventory createCartographyInventory(@NotNull Player player, @NotNull ComponentWrapper title) {
        return ReflectionUtils.construct(CARTOGRAPHY_INVENTORY_CONSTRUCTOR, player, title);
    }
}

