/*
 * Decompiled with CFR 0.152.
 */
package de.studiocode.inventoryaccess.r8.inventory;

import de.studiocode.inventoryaccess.abstraction.inventory.AnvilInventory;
import de.studiocode.inventoryaccess.component.ComponentWrapper;
import de.studiocode.inventoryaccess.r8.util.InventoryUtilsImpl;
import java.util.function.Consumer;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindow;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutWindowItems;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerAnvil;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.level.World;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_18_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_18_R1.inventory.CraftInventoryAnvil;
import org.bukkit.craftbukkit.v1_18_R1.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.v1_18_R1.inventory.CraftItemStack;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class AnvilInventoryImpl
extends ContainerAnvil
implements AnvilInventory {
    private final IChatBaseComponent title;
    private final Consumer<String> renameHandler;
    private final CraftInventoryView view;
    private final EntityPlayer player;
    private String text;
    private boolean open;

    public AnvilInventoryImpl(Player player, @NotNull ComponentWrapper title, Consumer<String> renameHandler) {
        this(((CraftPlayer)player).getHandle(), InventoryUtilsImpl.createNMSComponent(title), renameHandler);
    }

    public AnvilInventoryImpl(EntityPlayer player, IChatBaseComponent title, Consumer<String> renameHandler) {
        super(player.nextContainerCounter(), player.fq(), ContainerAccess.a((World)player.t, (BlockPosition)new BlockPosition(0, 0, 0)));
        this.title = title;
        this.renameHandler = renameHandler;
        this.player = player;
        CraftInventoryAnvil inventory = new CraftInventoryAnvil(this.q.getLocation(), this.p, (IInventory)this.o, (ContainerAnvil)this);
        this.view = new CraftInventoryView((HumanEntity)player.getBukkitEntity(), (Inventory)inventory, (Container)this);
    }

    @Override
    public void open() {
        this.open = true;
        CraftEventFactory.callInventoryOpenEvent((EntityPlayer)this.player, (Container)this);
        this.player.bW = this;
        this.player.b.a((Packet)new PacketPlayOutOpenWindow(this.j, Containers.h, this.title));
        NonNullList itemsList = NonNullList.a((Object)net.minecraft.world.item.ItemStack.b, (Object[])new net.minecraft.world.item.ItemStack[]{this.getItem(0), this.getItem(1), this.getItem(2)});
        this.player.b.a((Packet)new PacketPlayOutWindowItems(this.getActiveWindowId(this.player), this.k(), itemsList, net.minecraft.world.item.ItemStack.b));
        this.player.a((Container)this);
    }

    public void sendItem(int slot) {
        this.player.b.a((Packet)new PacketPlayOutSetSlot(this.getActiveWindowId(this.player), slot, this.k(), this.getItem(slot)));
    }

    public void setItem(int slot, net.minecraft.world.item.ItemStack item) {
        if (slot < 2) {
            this.p.a(slot, item);
        } else {
            this.o.a(0, item);
        }
        if (this.open) {
            this.sendItem(slot);
        }
    }

    private net.minecraft.world.item.ItemStack getItem(int slot) {
        if (slot < 2) {
            return this.p.a(slot);
        }
        return this.o.a(0);
    }

    private int getActiveWindowId(EntityPlayer player) {
        Container container = player.bW;
        return container == null ? -1 : container.j;
    }

    @Override
    public void setItem(int slot, ItemStack itemStack) {
        this.setItem(slot, CraftItemStack.asNMSCopy((ItemStack)itemStack));
    }

    @Override
    @NotNull
    public Inventory getBukkitInventory() {
        return this.view.getTopInventory();
    }

    @Override
    public String getRenameText() {
        return this.text;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    public CraftInventoryView getBukkitView() {
        return this.view;
    }

    public boolean a(EntityHuman player) {
        return true;
    }

    public void a(String s) {
        this.text = s;
        if (this.renameHandler != null) {
            this.renameHandler.accept(s);
        }
        this.sendItem(2);
    }

    public void b(EntityHuman player) {
        this.open = false;
    }

    protected void a(EntityHuman player, IInventory container) {
        this.open = false;
    }

    public void l() {
    }
}

