/*
 * Decompiled with CFR 0.152.
 */
package com.itsrainingplex.Towny;

import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Resident;
import java.util.Objects;
import org.bukkit.entity.Player;

public class TownyManager {
    public String getTownRank(Player player) {
        Resident resident = TownyAPI.getInstance().getResident(player.getUniqueId());
        assert (resident != null);
        for (String s : resident.getTownRanks()) {
            if (!resident.hasTownRank(s)) continue;
            return s;
        }
        return "";
    }

    public String getNationRank(Player player) {
        Resident resident = TownyAPI.getInstance().getResident(player.getUniqueId());
        assert (resident != null);
        for (String s : resident.getNationRanks()) {
            if (!resident.hasNationRank(s)) continue;
            return s;
        }
        return "";
    }

    public boolean checkMayor(Player player) {
        Resident resident = TownyAPI.getInstance().getResident(player.getUniqueId());
        assert (resident != null);
        return resident.isMayor();
    }

    public boolean checkKing(Player player) {
        Resident resident = TownyAPI.getInstance().getResident(player.getUniqueId());
        assert (resident != null);
        return resident.isKing();
    }

    public String getKingName(Player player) {
        String s = "";
        if (!Objects.requireNonNull(TownyAPI.getInstance().getResident(player.getUniqueId())).hasNation()) {
            return s;
        }
        try {
            s = Objects.requireNonNull(TownyAPI.getInstance().getResident(player.getUniqueId())).getNation().getKing().getNamePrefix();
        }
        catch (TownyException e) {
            e.printStackTrace();
        }
        return s.trim();
    }

    public String getMayorName(Player player) {
        String s = "";
        if (!Objects.requireNonNull(TownyAPI.getInstance().getResident(player.getUniqueId())).hasTown()) {
            return s;
        }
        try {
            s = Objects.requireNonNull(TownyAPI.getInstance().getResident(player.getUniqueId())).getTown().getMayor().getNamePrefix();
        }
        catch (NotRegisteredException e) {
            e.printStackTrace();
        }
        return s.trim();
    }

    public String getTownName(Player player) {
        String s = "";
        if (!Objects.requireNonNull(TownyAPI.getInstance().getResident(player.getUniqueId())).hasTown()) {
            return s;
        }
        try {
            s = Objects.requireNonNull(TownyAPI.getInstance().getResident(player.getUniqueId())).getTown().getName();
        }
        catch (NotRegisteredException e) {
            e.printStackTrace();
        }
        return s.trim();
    }

    public String getNationName(Player player) {
        String s = "";
        if (!Objects.requireNonNull(TownyAPI.getInstance().getResident(player.getUniqueId())).hasNation()) {
            return s;
        }
        try {
            s = Objects.requireNonNull(TownyAPI.getInstance().getResident(player.getUniqueId())).getNation().getName();
        }
        catch (TownyException e) {
            e.printStackTrace();
        }
        return s.trim();
    }
}

