/*
 * Decompiled with CFR 0.152.
 */
package com.itsrainingplex.SQLite;

import com.itsrainingplex.RaindropQuests;
import com.itsrainingplex.SQLite.Database;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;

public class SQLite
extends Database {
    private final RaindropQuests plugin;
    public String dbname;
    public String main_table = "RaindropQuests";
    public String questLastTable = "quest_last";
    public String questsCompletedTable = "quests_tally";
    public String passiveTable = "passives";
    public String counterTable = "counter";
    public StringBuilder counterTableToken = new StringBuilder("CREATE TABLE IF NOT EXISTS " + this.counterTable + " (`uuid` varchar(32) NOT NULL, `playerkills` int(7) NOT NULL,");
    public StringBuilder questsTableToken = new StringBuilder("CREATE TABLE IF NOT EXISTS " + this.questLastTable + " (`uuid` varchar(32) NOT NULL,`player` varchar(255) NOT NULL,");
    public StringBuilder questsCompleteTableToken = new StringBuilder("CREATE TABLE IF NOT EXISTS " + this.questsCompletedTable + " (`uuid` varchar(32) NOT NULL,`player` varchar(255) NOT NULL,");
    public StringBuilder mainTableToken = new StringBuilder("CREATE TABLE IF NOT EXISTS " + this.main_table + " (`uuid` varchar(32) NOT NULL,`player` varchar(255) NOT NULL,`currency` int(11) NOT NULL,`quests` int(11) NOT NULL,`wood_passive` int(1) NOT NULL,`iron_passive` int(1) NOT NULL,`gold_passive` int(1) NOT NULL,`diamond_passive` int(1) NOT NULL,`nether_passive` int(1) NOT NULL,`bonus_passive` int(1) NOT NULL,`potion_return` int(1) NOT NULL,`potion_extend` int(1) NOT NULL,`potion_strength` int(1) NOT NULL,`superheat` int(1) NOT NULL,`transmogrification` int(1) NOT NULL,`craftnethertools` int(1) NOT NULL,`craftnetherweapons` int(1) NOT NULL,`craftnetherarmor` int(1) NOT NULL,`condense` int(1) NOT NULL,`expedire` int(1) NOT NULL,`mixologist` int(1) NOT NULL,`transmutation` int(1) NOT NULL,`passive18` int(1),`passive19` int(1),PRIMARY KEY (`uuid`));");
    public StringBuilder blockTableToken = new StringBuilder("CREATE TABLE IF NOT EXISTS " + this.blockData + " (`id` int(64) NOT NULL,`blockdata` varchar(1024) NOT NULL,PRIMARY KEY (`id`));");
    public StringBuilder passivesTableToken = new StringBuilder("CREATE TABLE IF NOT EXISTS " + this.passiveTable + " (`uuid` varchar(32) NOT NULL,`player` varchar(255) NOT NULL,`wood_passive` varchar(255) NOT NULL,`iron_passive` varchar(255) NOT NULL,`gold_passive` varchar(255) NOT NULL,`diamond_passive` varchar(255) NOT NULL,`nether_passive` varchar(255) NOT NULL,`bonus_passive` varchar(255) NOT NULL,`potion_return` varchar(255) NOT NULL,`potion_extend` varchar(255) NOT NULL,`potion_strength` varchar(255) NOT NULL,`superheat` varchar(255) NOT NULL,`transmogrification` varchar(255) NOT NULL,`craftnethertools` varchar(255) NOT NULL,`craftnetherweapons` varchar(255) NOT NULL,`craftnetherarmor` varchar(255) NOT NULL,`condense` varchar(255) NOT NULL,`expedire` varchar(255) NOT NULL,`mixologist` varchar(255) NOT NULL,`transmutation` varchar(255) NOT NULL,`passive18` varchar(255),`passive19` varchar(255),PRIMARY KEY (`uuid`));");

    public SQLite(RaindropQuests plugin) {
        super(plugin);
        int i;
        this.plugin = plugin;
        this.dbname = plugin.getConfig().getString("SQLite.Filename", this.main_table);
        for (i = 0; i < plugin.settings.numberOfQuests - 1; ++i) {
            this.questsTableToken.append("`").append(plugin.settings.quests.get(i).getName()).append("` varchar(32) NOT NULL,");
        }
        this.questsTableToken.append("`").append(plugin.settings.quests.get(plugin.settings.numberOfQuests - 1).getName()).append("` varchar(32) NOT NULL,PRIMARY KEY (`uuid`));");
        for (i = 0; i < plugin.settings.numberOfQuests - 1; ++i) {
            this.questsCompleteTableToken.append("`").append(plugin.settings.quests.get(i).getName()).append("` varchar(32) NOT NULL,");
        }
        this.questsCompleteTableToken.append("`").append(plugin.settings.quests.get(plugin.settings.numberOfQuests - 1).getName()).append("` varchar(32) NOT NULL,PRIMARY KEY (`uuid`));");
        for (String s : plugin.settings.allMobTypes) {
            this.counterTableToken.append(s).append(" int(7) NOT NULL,");
        }
        this.counterTableToken.append("PRIMARY KEY (uuid));");
    }

    @Override
    public Connection getSQLConnection() {
        File dataFolder = new File(this.plugin.getDataFolder(), this.dbname + ".db");
        if (!dataFolder.exists()) {
            try {
                boolean created = dataFolder.createNewFile();
                if (this.plugin.settings.pm.getExtendedDebug() && created) {
                    this.plugin.getLogger().info("SQLite database file created");
                }
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.SEVERE, "File write error: " + this.dbname + ".db");
            }
        }
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                return this.connection;
            }
            Class.forName("org.sqlite.JDBC");
            this.connection = DriverManager.getConnection("jdbc:sqlite:" + dataFolder);
            return this.connection;
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, "SQLite exception on initialize", ex);
        }
        catch (ClassNotFoundException ex) {
            this.plugin.getLogger().log(Level.SEVERE, "You need the SQLite JBDC library. Google it. Put it in /lib folder.");
        }
        return null;
    }

    @Override
    public void load() {
        this.connection = this.getSQLConnection();
        try {
            Statement s = this.connection.createStatement();
            s.executeUpdate(this.mainTableToken.toString());
            s.executeUpdate(this.questsTableToken.toString());
            s.executeUpdate(this.questsCompleteTableToken.toString());
            s.executeUpdate(this.blockTableToken.toString());
            s.executeUpdate(this.passivesTableToken.toString());
            s.executeUpdate(this.counterTableToken.toString());
            s.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.initialize();
    }
}

