/*
 * Decompiled with CFR 0.152.
 */
package com.itsrainingplex.SQLite;

import com.itsrainingplex.Block.Block;
import com.itsrainingplex.MySQL.SQLGetter;
import com.itsrainingplex.RaindropQuests;
import com.itsrainingplex.SQLite.Errors;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.logging.Level;
import org.bukkit.entity.Player;

public abstract class Database {
    private final RaindropQuests plugin;
    public Connection connection;
    public String main = "RaindropQuests";
    private final String questLastTable = "quest_last";
    private final String questsTable = "quests_tally";
    public String blockData = "block_data";
    public String passives = "passives";
    private final String counter = "counter";

    public Database(RaindropQuests plugin) {
        this.plugin = plugin;
    }

    public abstract Connection getSQLConnection();

    public abstract void load();

    public void initialize() {
        this.connection = this.getSQLConnection();
        try {
            PreparedStatement ps = this.connection.prepareStatement("SELECT * FROM " + this.main + " WHERE uuid = ?");
            PreparedStatement ps2 = this.connection.prepareStatement("SELECT * FROM quests_tally WHERE uuid = ?");
            PreparedStatement ps3 = this.connection.prepareStatement("SELECT * FROM quest_last WHERE uuid = ?");
            PreparedStatement ps4 = this.connection.prepareStatement("SELECT * FROM " + this.blockData + " WHERE blockdata = ?");
            PreparedStatement ps5 = this.connection.prepareStatement("SELECT * FROM " + this.passives + " WHERE uuid = ?");
            PreparedStatement ps6 = this.connection.prepareStatement("SELECT * FROM counter WHERE uuid = ?");
            ResultSet rs = ps.executeQuery();
            ResultSet rs2 = ps2.executeQuery();
            ResultSet rs3 = ps3.executeQuery();
            ResultSet rs4 = ps4.executeQuery();
            ResultSet rs5 = ps5.executeQuery();
            ResultSet rs6 = ps6.executeQuery();
            this.close(ps, rs);
            this.close(ps2, rs2);
            this.close(ps3, rs3);
            this.close(ps4, rs4);
            this.close(ps5, rs5);
            this.close(ps6, rs6);
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void loadAllKillData() {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.getSQLConnection();
            ps = conn.prepareStatement("SELECT * FROM counter;");
            SQLGetter.runKillDataFromLoad(ps, this.plugin);
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionClose(), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKillCount(String uuid, String mob, Integer amount) {
        this.plugin.getLogger().info(mob);
        if (amount == null) {
            return;
        }
        Connection conn = null;
        Statement ps = null;
        try {
            conn = this.getSQLConnection();
            ps = conn.prepareStatement("UPDATE counter SET " + mob + "=" + amount + " WHERE uuid=?");
            ps.setString(1, uuid);
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info("Running query: " + (PreparedStatement)ps);
            }
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionClose(), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getCurrency(String uuid) {
        Connection conn = null;
        Statement ps = null;
        try {
            conn = this.getSQLConnection();
            ps = conn.prepareStatement("SELECT * FROM " + this.main + " WHERE uuid = '" + uuid + "';");
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info("Running query: " + ps.toString());
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                if (!rs.getString("uuid").equalsIgnoreCase(uuid)) continue;
                Integer n = rs.getInt("currency");
                return n;
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionClose(), ex);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPlayer(String uuid, String table) {
        Connection conn = null;
        Statement ps = null;
        try {
            conn = this.getSQLConnection();
            ps = conn.prepareStatement("SELECT * FROM " + table + " WHERE uuid = '" + uuid + "';");
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info("Running query: " + ps.toString());
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                if (!rs.getString("uuid").equalsIgnoreCase(uuid)) continue;
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionClose(), ex);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getQuests(String uuid) {
        Connection conn = null;
        Statement ps = null;
        try {
            conn = this.getSQLConnection();
            ps = conn.prepareStatement("SELECT * FROM " + this.main + " WHERE uuid = '" + uuid + "';");
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info("Running query: " + ps.toString());
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                if (!rs.getString("uuid").equalsIgnoreCase(uuid)) continue;
                Integer n = rs.getInt("quests");
                return n;
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionClose(), ex);
            }
        }
        return 0;
    }

    public String getQuestTime(String uuid, String quest) {
        return this.getQuest(uuid, quest, "quest_last");
    }

    public String getQuestTally(String uuid, String quest) {
        return this.getQuest(uuid, quest, "quests_tally");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getQuest(String uuid, String quest, String table) {
        Connection conn = null;
        Statement ps = null;
        try {
            conn = this.getSQLConnection();
            ps = conn.prepareStatement("SELECT * FROM " + table + " WHERE uuid = '" + uuid + "';");
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info("Running query: " + ps.toString());
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                if (!rs.getString("uuid").equalsIgnoreCase(uuid)) continue;
                String string = rs.getString(quest);
                return string;
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionClose(), ex);
            }
        }
        return "0";
    }

    public ArrayList<String> getAllPlayers() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            Connection conn = this.getSQLConnection();
            PreparedStatement ps = conn.prepareStatement("SELECT uuid FROM " + this.main);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                list.add(rs.getString("uuid"));
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Block> getBlockData() {
        Connection conn = null;
        Statement ps = null;
        ArrayList<String> temp = new ArrayList<String>();
        try {
            conn = this.getSQLConnection();
            ps = conn.prepareStatement("SELECT * FROM " + this.blockData + ";");
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info("Running query: " + ps.toString());
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                temp.add(rs.getString("blockdata").replaceAll("\"\"", "\""));
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionClose(), ex);
            }
        }
        return this.plugin.settings.blockHandler.loadBlockData(temp);
    }

    public void setDateTable(Player player, String[] str) {
        this.setTable(player, str, "quest_last");
    }

    public void setQuestsTable(Player player, String[] str) {
        this.setTable(player, str, "quests_tally");
    }

    public void setPassivesTable(Player player, String[] str) {
        this.runPassiveSet(player, str, this.passives);
    }

    public String getPassiveTime(String uuid, String passive) {
        return this.getQuest(uuid, passive, this.passives);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPassive(Player player, String passive, Integer value) {
        Connection conn = null;
        Statement ps = null;
        try {
            conn = this.getSQLConnection();
            ps = conn.prepareStatement("UPDATE " + this.main + " set " + passive.toLowerCase() + "=" + value + " WHERE uuid=\"" + player.getUniqueId() + "\"");
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info("Running query: " + ps.toString());
            }
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionClose(), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrency(Player player, Integer value) {
        Connection conn = null;
        Statement ps = null;
        try {
            conn = this.getSQLConnection();
            ps = conn.prepareStatement("UPDATE " + this.main + " set currency=" + value + " WHERE uuid=\"" + player.getUniqueId() + "\"");
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info("Running query: " + ps.toString());
            }
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionClose(), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getKillCount(String uuid, String entity) {
        Connection conn = null;
        Statement ps = null;
        try {
            conn = this.getSQLConnection();
            ps = conn.prepareStatement("SELECT * FROM counter WHERE uuid = '" + uuid + "';");
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info("Running query: " + ps.toString());
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                if (!rs.getString("uuid").equalsIgnoreCase(uuid)) continue;
                int n = rs.getInt(entity);
                return n;
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionClose(), ex);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBlockData(ArrayList<String> data) {
        if (this.plugin.settings.pm.getDebug()) {
            this.plugin.getLogger().info("Updating block data..");
        }
        for (int i = 0; i < data.size(); ++i) {
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info(data.get(i));
            }
            Connection conn = null;
            Statement ps = null;
            String s = data.get(i);
            s = s.replaceAll("\"", "\"\"");
            try {
                conn = this.getSQLConnection();
                ps = conn.prepareStatement("REPLACE INTO " + this.blockData + "(id,blockdata) VALUES(?,?)");
                ps.setInt(1, i);
                ps.setString(2, s);
                if (this.plugin.settings.pm.getExtendedDebug()) {
                    this.plugin.getLogger().info("Running query: " + (PreparedStatement)ps);
                }
                ps.executeUpdate();
                continue;
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
                continue;
            }
            finally {
                try {
                    if (ps != null) {
                        ps.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException ex) {
                    this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionClose(), ex);
                }
            }
        }
        if (this.plugin.settings.pm.getDebug()) {
            this.plugin.getLogger().info("Block data updated..");
        }
        Database.messageBlockUpdate(data, this.plugin);
    }

    public static void messageBlockUpdate(ArrayList<String> data, RaindropQuests plugin) {
        if (plugin.settings.pm.getExtendedDebug()) {
            plugin.getLogger().info(data.toString());
        }
        if (plugin.settings.pm.getDebug()) {
            if (data.size() < 2) {
                if (data.size() % 5 == 0) {
                    plugin.getLogger().info("Loaded approximately " + data.size() * 5 + " blocks  into " + data.size() + " rows");
                } else {
                    plugin.getLogger().info("Loaded approximately " + data.get(0).length() / 81 + " blocks  into " + data.size() + " rows");
                }
            } else {
                plugin.getLogger().info("Loaded approximately " + (data.size() * 5 + data.get(data.size() - 1).length() / 81) + " blocks  into " + data.size() + " rows");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getPassiveStatus(Player player, String passive) {
        if (this.plugin.settings.pm.getExtendedDebug()) {
            this.plugin.getLogger().info("Getting passive status for " + player.getName() + "...");
        }
        Connection conn = null;
        Statement ps = null;
        try {
            conn = this.getSQLConnection();
            ps = conn.prepareStatement("SELECT " + passive.toLowerCase() + " FROM " + this.main + " WHERE uuid =\"" + player.getUniqueId() + "\"");
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info("Running query: " + ps.toString());
            }
            ResultSet rs = ps.executeQuery();
            Integer n = rs.getInt(passive);
            return n;
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionClose(), ex);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTable(Player player, String[] str, String table) {
        if (this.plugin.settings.pm.getDebug()) {
            this.plugin.getLogger().info("Updating data for " + player.getName() + "...");
        }
        Connection conn = null;
        Statement ps = null;
        try {
            conn = this.getSQLConnection();
            String statement = "REPLACE INTO " + table + " (uuid,player,";
            ps = SQLGetter.getPreparedStatementQuest(conn, statement, this.plugin);
            this.setupStatement(player, str, (PreparedStatement)ps);
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionClose(), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runPassiveSet(Player player, String[] str, String table) {
        Connection conn = null;
        Statement ps = null;
        try {
            conn = this.getSQLConnection();
            String statement = "REPLACE INTO " + table + " (uuid,player,";
            ps = Database.getPreparedStatementPassive(conn, statement, this.plugin);
            this.setupStatement(player, str, (PreparedStatement)ps);
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionClose(), ex);
            }
        }
    }

    private void setupStatement(Player player, String[] str, PreparedStatement ps) throws SQLException {
        ps.setString(1, player.getUniqueId().toString());
        ps.setString(2, player.getName().toLowerCase());
        for (int i = 3; i < str.length + 3; ++i) {
            ps.setString(i, str[i - 3]);
        }
        if (this.plugin.settings.pm.getExtendedDebug()) {
            this.plugin.getLogger().info("Running query: " + ps);
        }
        ps.executeUpdate();
    }

    public static PreparedStatement getPreparedStatementPassive(Connection conn, String statement, RaindropQuests plugin) throws SQLException {
        StringBuilder statementBuilder = new StringBuilder((String)statement);
        for (String st : plugin.settings.passiveNames) {
            statementBuilder.append(st).append(",");
        }
        statement = statementBuilder.toString();
        statement = ((String)statement).substring(0, ((String)statement).length() - 1);
        statement = (String)statement + ") VALUES(?,?,";
        statement = (String)statement + "?,".repeat(plugin.settings.passiveNames.size());
        statement = ((String)statement).substring(0, ((String)statement).length() - 1);
        statement = (String)statement + ")";
        PreparedStatement ps = conn.prepareStatement((String)statement);
        return ps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPlayerToCounterTable(Player player) {
        Connection conn = null;
        Statement ps = null;
        try {
            conn = this.getSQLConnection();
            StringBuilder statement = new StringBuilder("REPLACE INTO counter (uuid,playerkills,");
            for (String s : this.plugin.settings.allMobTypes) {
                statement.append(s).append(",");
            }
            statement = new StringBuilder(statement.substring(0, statement.length() - 1));
            statement.append(") VALUES(\"").append(player.getUniqueId()).append("\",");
            statement.append("0,");
            statement.append("0,".repeat(this.plugin.settings.allMobTypes.size()));
            statement = new StringBuilder(statement.substring(0, statement.length() - 1));
            statement.append(")");
            this.plugin.getLogger().info(statement.toString());
            ps = conn.prepareStatement(statement.toString());
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionClose(), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMainTable(Player player, Integer currency, Integer quests, Integer wood_passive, Integer iron_passive, Integer gold_passive, Integer diamond_passive, Integer nether_passive, Integer bonus_passive, Integer potion_return, Integer potion_extend, Integer potion_strength, Integer superheat, Integer transmog, Integer CraftNetherTools, Integer CraftNetherWeapons, Integer CraftNetherArmor, Integer condense, Integer expedire, Integer mixologist, Integer transmutation, Integer passive18, Integer passive19) {
        Connection conn = null;
        Statement ps = null;
        try {
            conn = this.getSQLConnection();
            ps = conn.prepareStatement("REPLACE INTO " + this.main + " (uuid,player,currency,quests,wood_passive,iron_passive,gold_passive,diamond_passive,nether_passive,bonus_passive,potion_return,potion_extend,potion_strength,superheat,transmogrification,craftnethertools,craftnetherweapons,craftnetherarmor,condense,expedire,mixologist,transmutation,passive18,passive19) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            SQLGetter.setupPreparedStatement(player, currency, quests, wood_passive, iron_passive, gold_passive, diamond_passive, nether_passive, bonus_passive, potion_return, potion_extend, potion_strength, superheat, transmog, CraftNetherTools, CraftNetherWeapons, CraftNetherArmor, condense, expedire, mixologist, transmutation, passive18, passive19, (PreparedStatement)ps);
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionClose(), ex);
            }
        }
    }

    public void close(PreparedStatement ps, ResultSet rs) {
        try {
            if (ps != null) {
                ps.close();
            }
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().severe(ex.toString());
        }
    }
}

