/*
 * Decompiled with CFR 0.152.
 */
package com.itsrainingplex.Ranks;

import com.gamingmesh.jobs.Jobs;
import com.gamingmesh.jobs.container.JobProgression;
import com.gamingmesh.jobs.container.JobsPlayer;
import com.gmail.nossr50.api.ExperienceAPI;
import com.itsrainingplex.RaindropQuests;
import com.itsrainingplex.Ranks.Rank;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.luckperms.api.node.NodeType;
import net.luckperms.api.node.types.InheritanceNode;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.NotNull;

public class RankManager {
    private final RaindropQuests plugin;

    public RankManager(RaindropQuests plugin) {
        this.plugin = plugin;
    }

    public boolean check_InventoryCost(Player player, Rank rank) {
        if (rank != null) {
            if (!rank.costMap.isEmpty()) {
                for (String s : rank.costMap.keySet()) {
                    String[] str;
                    if (rank.costMap.get(s) == null || (str = (s = s.toLowerCase()).split(":"))[0].equalsIgnoreCase("JobsReborn") || str[0].equalsIgnoreCase("mcMMO") || s.equalsIgnoreCase("Economy")) continue;
                    ItemStack item = s.contains("potion".toLowerCase()) ? RankManager.getPotionItemStack(s, str) : new ItemStack(Material.valueOf((String)s.toUpperCase()));
                    ItemMeta itemMeta = item.getItemMeta();
                    if (itemMeta instanceof Damageable) {
                        Damageable dm = (Damageable)itemMeta;
                        if (item.getType().getMaxStackSize() == 1) {
                            dm = (Damageable)item.getItemMeta();
                            if (dm == null || dm.hasDamage() || this.countInventory((Inventory)player.getInventory(), item) >= rank.costMap.get(s)) continue;
                            return false;
                        }
                    }
                    if (!player.getInventory().contains(item) || this.countInventory((Inventory)player.getInventory(), item) >= rank.costMap.get(s)) continue;
                    return false;
                }
            }
        } else {
            return false;
        }
        return true;
    }

    @NotNull
    public static ItemStack getPotionItemStack(String s, String[] str) {
        ItemStack item = s.contains("splash") ? new ItemStack(Material.SPLASH_POTION) : new ItemStack(Material.POTION);
        PotionMeta meta = (PotionMeta)item.getItemMeta();
        if (s.contains("long")) {
            String temp = str[1].substring(str[1].indexOf(95) + 1, str[1].length() - 1);
            if (temp.equalsIgnoreCase("healing")) {
                temp = "instant_heal";
            } else if (temp.equalsIgnoreCase("swiftness")) {
                temp = "speed";
            } else if (temp.equalsIgnoreCase("leaping")) {
                temp = "jump";
            } else if (temp.equalsIgnoreCase("regeneration")) {
                temp = "regen";
            }
            PotionData data = new PotionData(PotionType.valueOf((String)temp.toUpperCase()), true, false);
            assert (meta != null);
            meta.setBasePotionData(data);
            item.setItemMeta((ItemMeta)meta);
        } else if (s.contains("strong")) {
            String temp = str[1].substring(str[1].indexOf(95) + 1, str[1].length() - 1);
            if (temp.equalsIgnoreCase("healing")) {
                temp = "instant_heal";
            } else if (temp.equalsIgnoreCase("swiftness")) {
                temp = "speed";
            } else if (temp.equalsIgnoreCase("leaping")) {
                temp = "jump";
            } else if (temp.equalsIgnoreCase("regeneration")) {
                temp = "regen";
            }
            PotionData data = new PotionData(PotionType.valueOf((String)temp.toUpperCase()), false, true);
            assert (meta != null);
            meta.setBasePotionData(data);
            item.setItemMeta((ItemMeta)meta);
        }
        return item;
    }

    public void removeItem(@NotNull Player player, ItemStack providedItem, int amount) {
        boolean stackable;
        Damageable dm;
        PlayerInventory inventory = player.getInventory();
        if (providedItem.getItemMeta() instanceof Damageable && providedItem.getType().getMaxStackSize() == 1) {
            dm = (Damageable)providedItem.getItemMeta();
            stackable = false;
        } else {
            dm = null;
            stackable = true;
        }
        int temp = 0;
        if (stackable) {
            for (ItemStack item : inventory.getContents()) {
                if (item == null || !item.getType().equals((Object)providedItem.getType())) continue;
                temp = this.countInventory((Inventory)inventory, providedItem);
            }
            if (temp > 0) {
                ItemStack itemStack = new ItemStack(providedItem.getType(), 64);
                ItemStack remainder = new ItemStack(providedItem.getType(), (temp -= amount) % 64);
                inventory.remove(providedItem.getType());
                for (int j = 0; j < temp / 64; ++j) {
                    player.getInventory().addItem(new ItemStack[]{itemStack});
                }
                player.getInventory().addItem(new ItemStack[]{remainder});
            }
        } else {
            temp = amount;
            for (ItemStack item : inventory.getContents()) {
                if (item == null) continue;
                ItemMeta itemMeta = providedItem.getItemMeta();
                if (itemMeta instanceof PotionMeta) {
                    PotionMeta meta = (PotionMeta)itemMeta;
                    itemMeta = item.getItemMeta();
                    if (itemMeta instanceof PotionMeta) {
                        PotionMeta meta2 = (PotionMeta)itemMeta;
                        PotionData data = meta.getBasePotionData();
                        PotionData data2 = meta2.getBasePotionData();
                        if (!data.getType().equals((Object)data2.getType()) || Boolean.compare(data.isUpgraded(), data2.isUpgraded()) != 0 || Boolean.compare(data.isExtended(), data2.isExtended()) != 0) continue;
                        inventory.removeItem(new ItemStack[]{item});
                        --temp;
                        continue;
                    }
                }
                if (dm == null || dm.hasDamage() || !item.getType().equals((Object)providedItem.getType())) continue;
                inventory.removeItem(new ItemStack[]{item});
                --temp;
            }
        }
    }

    public int countInventory(Inventory inventory, ItemStack item) {
        int temp = 0;
        for (ItemStack i : inventory.getContents()) {
            if (i == null) continue;
            ItemMeta itemMeta = i.getItemMeta();
            if (itemMeta instanceof PotionMeta) {
                PotionMeta meta = (PotionMeta)itemMeta;
                itemMeta = item.getItemMeta();
                if (itemMeta instanceof PotionMeta) {
                    PotionMeta meta2 = (PotionMeta)itemMeta;
                    PotionData data = meta.getBasePotionData();
                    PotionData data2 = meta2.getBasePotionData();
                    if (!data.getType().equals((Object)data2.getType()) || Boolean.compare(data.isUpgraded(), data2.isUpgraded()) != 0 || Boolean.compare(data.isExtended(), data2.isExtended()) != 0) continue;
                    ++temp;
                    continue;
                }
            }
            if (!i.getType().equals((Object)item.getType())) continue;
            temp += i.getAmount();
        }
        return temp;
    }

    public boolean check_EconomyCost(Player player, Rank rank) {
        if (rank != null && !rank.costMap.isEmpty()) {
            for (String s : rank.costMap.keySet()) {
                if (!s.equalsIgnoreCase("Economy") || !(this.plugin.settings.economy.getBalance((OfflinePlayer)player) < (double)rank.costMap.get(s).intValue())) continue;
                return false;
            }
        }
        return true;
    }

    public boolean check_mcMMO_level(Player player, Rank rank) {
        if (rank != null && !rank.mcMMOMap.isEmpty()) {
            for (String s : rank.mcMMOMap.keySet()) {
                if (!(s.equalsIgnoreCase("Total") ? rank.mcMMOMap.get(s) > ExperienceAPI.getPowerLevel((Player)player) : rank.mcMMOMap.get(s) > ExperienceAPI.getLevelOffline((UUID)player.getUniqueId(), (String)s))) continue;
                return false;
            }
        }
        return true;
    }

    public boolean check_Custom_Currency(Player player, Rank rank) {
        if (rank != null && !rank.costMap.isEmpty()) {
            for (String s : rank.costMap.keySet()) {
                if (!s.equalsIgnoreCase(this.plugin.settings.customMoneyName) || !(this.plugin.settings.dbType.equalsIgnoreCase("SQLite") ? rank.costMap.get(s) > this.plugin.settings.db.getCurrency(player.getUniqueId().toString()) : rank.costMap.get(s) > this.plugin.settings.data.getCurrency(player.getUniqueId().toString()))) continue;
                return false;
            }
        }
        return true;
    }

    public void take_Custom_Currency(Player player, Rank rank) {
        if (rank != null && !rank.costMap.isEmpty()) {
            for (String s : rank.costMap.keySet()) {
                if (!s.equalsIgnoreCase(this.plugin.settings.customMoneyName)) continue;
                if (this.plugin.settings.dbType.equalsIgnoreCase("SQLite")) {
                    this.plugin.settings.db.setCurrency(player, this.plugin.settings.db.getCurrency(player.getUniqueId().toString()) - rank.costMap.get(s));
                    continue;
                }
                this.plugin.settings.data.setCurrency(player, this.plugin.settings.data.getCurrency(player.getUniqueId().toString()) - rank.costMap.get(s));
            }
        }
    }

    public boolean check_mcMMO_Level_Cost(Player player, Rank rank) {
        if (!rank.costMap.keySet().isEmpty()) {
            for (String str : rank.costMap.keySet()) {
                String[] s = str.split(":");
                if (!s[0].equalsIgnoreCase("mcMMO") || rank.costMap.get(str) <= ExperienceAPI.getLevelOffline((UUID)player.getUniqueId(), (String)s[1])) continue;
                return false;
            }
        }
        return true;
    }

    public boolean check_Kill_Requirement_SQLite(Player player, Rank rank) {
        if (rank != null && !rank.killsMap.isEmpty()) {
            for (String str : rank.killsMap.keySet()) {
                if (rank.killsMap.get(str) <= this.plugin.settings.db.getKillCount(player.getUniqueId().toString(), str)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean check_Kill_Requirement_MySQL(Player player, Rank rank) {
        if (rank != null && !rank.killsMap.isEmpty()) {
            for (String str : rank.killsMap.keySet()) {
                if (rank.killsMap.get(str) <= this.plugin.settings.data.getKillCount(player.getUniqueId().toString(), str)) continue;
                return false;
            }
        }
        return true;
    }

    public void take_mcMMO_Levels(Player player, Rank rank) {
        if (!rank.costMap.keySet().isEmpty()) {
            for (String str : rank.costMap.keySet()) {
                String[] s = str.split(":");
                if (!s[0].equalsIgnoreCase("mcMMO") || rank.costMap.get(str) >= ExperienceAPI.getLevelOffline((UUID)player.getUniqueId(), (String)s[1])) continue;
                int currentLevel = ExperienceAPI.getLevelOffline((UUID)player.getUniqueId(), (String)s[1]);
                ExperienceAPI.setLevel((Player)player, (String)s[1], (int)(currentLevel - rank.costMap.get(str)));
            }
        }
    }

    public boolean check_Jobs_Level(Player player, Rank rank) {
        if (rank != null && !rank.jobsMap.isEmpty()) {
            for (String s : rank.jobsMap.keySet()) {
                JobsPlayer jobsPlayer = Jobs.getPlayerManager().getJobsPlayer(player.getUniqueId());
                if (jobsPlayer == null) continue;
                List jobs = jobsPlayer.getJobProgression();
                for (JobProgression progression : jobs) {
                    if (!s.equalsIgnoreCase(progression.getJob().getName()) || rank.jobsMap.get(s) < progression.getLevel()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean check_Jobs_Cost(Player player, Rank rank) {
        boolean costFound = false;
        if (rank != null && !rank.costMap.isEmpty()) {
            for (String s : rank.costMap.keySet()) {
                String[] str = s.split(":");
                if (!str[0].equalsIgnoreCase("JobsReborn")) continue;
                costFound = true;
                JobsPlayer jobsPlayer = Jobs.getPlayerManager().getJobsPlayer(player.getUniqueId());
                if (jobsPlayer == null) continue;
                List jobs = jobsPlayer.getJobProgression();
                for (JobProgression progression : jobs) {
                    if (!progression.getJob().getName().equalsIgnoreCase(str[1]) || progression.getLevel() < rank.costMap.get(s)) continue;
                    return true;
                }
            }
        }
        return !costFound;
    }

    public void take_Jobs_Level(Player player, String job, int amount) {
        Bukkit.dispatchCommand((CommandSender)Bukkit.getServer().getConsoleSender(), (String)("jobs level " + player.getDisplayName() + " " + job + " take " + amount));
    }

    public List<String> get_RankUp_Requirements(@NotNull Rank rank) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Requirements:");
        if (!rank.mcMMOMap.keySet().isEmpty()) {
            list.add("mcMMO:");
            for (String string : rank.mcMMOMap.keySet()) {
                list.add(string + ": " + rank.mcMMOMap.get(string));
            }
        }
        if (!rank.jobsMap.keySet().isEmpty()) {
            list.add("Job:");
            for (String string : rank.jobsMap.keySet()) {
                list.add(string + ": " + rank.jobsMap.get(string));
            }
        }
        list.add("Cost:");
        if (!rank.costMap.keySet().isEmpty()) {
            for (String string : rank.costMap.keySet()) {
                String[] stringArray = string.split(":");
                if (stringArray[0].equalsIgnoreCase("JobsReborn")) {
                    list.add("[Jobs] " + stringArray[1] + ": " + rank.costMap.get(string));
                    continue;
                }
                if (stringArray[0].equalsIgnoreCase("mcMMO")) {
                    list.add("[mcMMO] " + stringArray[1] + ": " + rank.costMap.get(string));
                    continue;
                }
                if (stringArray[0].equalsIgnoreCase("Custom")) {
                    list.add(this.plugin.settings.customMoneyName + ": " + rank.costMap.get(string));
                    continue;
                }
                list.add(string + ": " + rank.costMap.get(string));
            }
        }
        list.add("Kills:");
        if (!rank.killsMap.keySet().isEmpty()) {
            for (String string : rank.killsMap.keySet()) {
                String[] stringArray = string.split(":");
                if (stringArray[0].equalsIgnoreCase("MC") || stringArray[0].equalsIgnoreCase("MM")) {
                    list.add(stringArray[1] + ": " + rank.killsMap.get(string));
                    continue;
                }
                if (stringArray[0].equalsIgnoreCase("playerkills")) {
                    list.add("PVP: " + rank.killsMap.get(string));
                    continue;
                }
                list.add(string + ": " + rank.killsMap.get(string));
            }
        }
        if (this.plugin.settings.ranks.treeType.equalsIgnoreCase("Tree")) {
            list.add("Ranks:");
            ArrayList<Rank> ranks = new ArrayList<Rank>();
            for (String string : rank.requiredRank) {
                ranks.add(this.plugin.settings.ranks.ranks.get(string.toLowerCase()));
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Rank r : ranks) {
                if (r == null) continue;
                arrayList.add(r.rankName);
            }
            String string2 = ((Object)arrayList).toString();
            string2 = string2.substring(1, string2.length() - 1);
            list.add(string2);
        }
        return list;
    }

    public boolean check_Required_Ranks(Player player, Rank rank) {
        List<String> requiredRanks = rank.requiredRank;
        Collection<String> groups = this.get_Player_Groups(player);
        for (String s : requiredRanks) {
            if (groups.contains(s.toLowerCase())) continue;
            return false;
        }
        return true;
    }

    public Collection<String> get_Player_Groups(Player player) {
        return this.plugin.settings.ranks.lpm.getLuckPermUser(player.getUniqueId()).getNodes().stream().filter(arg_0 -> ((NodeType)NodeType.INHERITANCE).matches(arg_0)).map(arg_0 -> ((NodeType)NodeType.INHERITANCE).cast(arg_0)).map(InheritanceNode::getGroupName).collect(Collectors.toSet());
    }

    public List<String> getAvailableRanks(Player player) {
        Collection<String> playerRanks = this.get_Player_Groups(player);
        ArrayList<String> path = new ArrayList<String>();
        for (String s : playerRanks) {
            Rank rank = null;
            for (Rank r : this.plugin.settings.ranks.ranks.values()) {
                if (!r.luckPermGroup.equalsIgnoreCase(s)) continue;
                rank = r;
            }
            if (rank == null) continue;
            for (String str : rank.path) {
                path.add(str.toLowerCase());
            }
        }
        ArrayList<String> upgrades = new ArrayList<String>();
        for (String s : path) {
            if (playerRanks.contains(s)) continue;
            upgrades.add(s.toUpperCase());
        }
        return upgrades;
    }

    public boolean checkRank(List<String> upgrades, String rankID) {
        for (String s : upgrades) {
            if (!s.equalsIgnoreCase(rankID)) continue;
            return true;
        }
        return false;
    }

    public boolean run_RankUp_Checks(Player player, Rank rank) {
        if (!this.plugin.settings.luckPerms) {
            if (this.plugin.settings.pm.getDebug()) {
                BaseComponent[] component = new ComponentBuilder("LuckPerms not installed").create();
                player.spigot().sendMessage(component);
            }
            return false;
        }
        if (!this.plugin.settings.ranks.lpm.checkGroups(this.plugin.settings.ranks.ranks)) {
            BaseComponent[] component = new ComponentBuilder("Groups do not match config").create();
            player.spigot().sendMessage(component);
            return false;
        }
        if (!player.hasPermission("RaindropQuests.ranks.RankUp")) {
            BaseComponent[] component = new ComponentBuilder("You do not have permission to rank up").create();
            player.spigot().sendMessage(component);
            return false;
        }
        if (this.plugin.settings.ranks.treeType.equalsIgnoreCase("Tree")) {
            if (this.getAvailableRanks(player).isEmpty()) {
                return false;
            }
            if (!this.checkRank(this.getAvailableRanks(player), rank.rankID.toLowerCase())) {
                List<String> upgrades = this.getAvailableRanks(player);
                ArrayList<Rank> ranks = new ArrayList<Rank>();
                for (String s : upgrades) {
                    ranks.add(this.plugin.settings.ranks.ranks.get(s.toLowerCase()));
                }
                ArrayList<String> names = new ArrayList<String>();
                for (Rank r : ranks) {
                    names.add(r.rankName);
                }
                BaseComponent[] component = new ComponentBuilder("You must purchase available rank: ").append(((Object)names).toString()).create();
                player.spigot().sendMessage(component);
                return false;
            }
            if (!this.check_Required_Ranks(player, rank)) {
                BaseComponent[] component = new ComponentBuilder("You failed to meet the required ranks!").create();
                player.spigot().sendMessage(component);
                return false;
            }
        }
        if (this.plugin.settings.mcMMO && !player.hasPermission("RaindropQuests.command.ranks.bypass.mcMMO")) {
            if (!this.check_mcMMO_Level_Cost(player, rank)) {
                BaseComponent[] component = new ComponentBuilder("You failed to meet the mcMMO level cost requirements!").create();
                player.spigot().sendMessage(component);
                return false;
            }
            if (!this.check_mcMMO_level(player, rank)) {
                BaseComponent[] component = new ComponentBuilder("You failed to meet the mcMMO Level Requirements!").create();
                player.spigot().sendMessage(component);
                return false;
            }
        }
        if (this.plugin.settings.jobs && !player.hasPermission("RaindropQuests.command.ranks.bypass.jobs")) {
            if (!this.check_Jobs_Level(player, rank)) {
                BaseComponent[] component = new ComponentBuilder("You failed to meet the Job Level Requirements!").create();
                player.spigot().sendMessage(component);
                return false;
            }
            if (!this.check_Jobs_Cost(player, rank)) {
                BaseComponent[] component = new ComponentBuilder("You failed to meet the Jobs Cost Requirements!").create();
                player.spigot().sendMessage(component);
                return false;
            }
        }
        if (this.plugin.settings.vault && !player.hasPermission("RaindropQuests.command.ranks.bypass.economy") && !this.check_EconomyCost(player, rank)) {
            BaseComponent[] component = new ComponentBuilder("You failed to meet the Economy Requirements!").create();
            player.spigot().sendMessage(component);
            return false;
        }
        if (!player.hasPermission("RaindropQuests.command.ranks.bypass.Custom") && !this.check_Custom_Currency(player, rank)) {
            BaseComponent[] component = new ComponentBuilder("You failed to meet the ").append(this.plugin.settings.customMoneyName).append(" requirements!").create();
            player.spigot().sendMessage(component);
            return false;
        }
        if (!player.hasPermission("RaindropQuests.command.ranks.bypass.items") && !this.check_InventoryCost(player, rank)) {
            BaseComponent[] component = new ComponentBuilder("You failed to meet the Item Requirements!").create();
            player.spigot().sendMessage(component);
            return false;
        }
        if (!player.hasPermission("RaindropQuests.command.ranks.bypass.kills")) {
            if (this.plugin.settings.dbType.equalsIgnoreCase("SQLite")) {
                if (!this.check_Kill_Requirement_SQLite(player, rank)) {
                    BaseComponent[] component = new ComponentBuilder("You failed to meet the Kill Requirements!").create();
                    player.spigot().sendMessage(component);
                    return false;
                }
            } else if (!this.check_Kill_Requirement_MySQL(player, rank)) {
                BaseComponent[] component = new ComponentBuilder("You failed to meet the Kill Requirements!").create();
                player.spigot().sendMessage(component);
                return false;
            }
        }
        return true;
    }
}

