/*
 * Decompiled with CFR 0.152.
 */
package com.itsrainingplex.Ranks;

import com.itsrainingplex.RaindropQuests;
import com.itsrainingplex.Ranks.Rank;
import de.studiocode.inventoryaccess.component.BaseComponentWrapper;
import de.studiocode.invui.item.ItemProvider;
import de.studiocode.invui.item.builder.ItemBuilder;
import de.studiocode.invui.item.impl.BaseItem;
import java.util.ArrayList;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemFlag;
import org.jetbrains.annotations.NotNull;

public class RankItem
extends BaseItem
implements Comparable<RankItem> {
    private final RaindropQuests plugin;
    public Rank rank;
    public boolean owned;

    public RankItem(RaindropQuests plugin, Rank rank) {
        this.plugin = plugin;
        this.rank = rank;
    }

    @Override
    public ItemProvider getItemProvider() {
        ArrayList<BaseComponentWrapper> cw = new ArrayList<BaseComponentWrapper>();
        if (this.owned) {
            BaseComponent[] component = new ComponentBuilder("Obtained").create();
            cw.add(new BaseComponentWrapper(component));
            return (ItemProvider)((ItemBuilder)((ItemBuilder)((ItemBuilder)new ItemBuilder(Material.valueOf((String)this.rank.material.toUpperCase())).setDisplayName(new ComponentBuilder(this.rank.rankName).color(ChatColor.BLUE).create())).setLore(cw)).addEnchantment(Enchantment.ARROW_DAMAGE, 1, true)).addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS, ItemFlag.HIDE_ATTRIBUTES});
        }
        if (this.rank == null) {
            return null;
        }
        for (String s : this.plugin.settings.ranks.rankManager.get_RankUp_Requirements(this.rank)) {
            BaseComponent[] component;
            if (s.equalsIgnoreCase("Requirements:")) {
                component = new ComponentBuilder(s).color(ChatColor.GREEN).bold(true).italic(true).create();
                cw.add(new BaseComponentWrapper(component));
                continue;
            }
            if (s.equalsIgnoreCase("mcMMO:")) {
                component = new ComponentBuilder(s).color(ChatColor.AQUA).bold(false).italic(false).create();
                cw.add(new BaseComponentWrapper(component));
                continue;
            }
            if (s.equalsIgnoreCase("Job:")) {
                component = new ComponentBuilder(s).color(ChatColor.DARK_PURPLE).bold(false).italic(false).create();
                cw.add(new BaseComponentWrapper(component));
                continue;
            }
            if (s.equalsIgnoreCase("Cost:")) {
                component = new ComponentBuilder(s).color(ChatColor.GOLD).bold(false).italic(false).create();
                cw.add(new BaseComponentWrapper(component));
                continue;
            }
            if (s.equalsIgnoreCase("Ranks:")) {
                component = new ComponentBuilder(s).color(ChatColor.RED).bold(false).italic(false).create();
                cw.add(new BaseComponentWrapper(component));
                continue;
            }
            if (s.equalsIgnoreCase("Kills:")) {
                component = new ComponentBuilder(s).color(ChatColor.LIGHT_PURPLE).bold(false).italic(false).create();
                cw.add(new BaseComponentWrapper(component));
                continue;
            }
            if (s.contains("potion")) {
                String[] str = s.split(":");
                String[] temp = new String[]{str[0] + ":" + str[1], str[2]};
                BaseComponent[] component2 = new ComponentBuilder(this.convertPotionID(temp[0])).color(ChatColor.WHITE).append(":").append(temp[1]).bold(false).italic(false).create();
                cw.add(new BaseComponentWrapper(component2));
                continue;
            }
            s = s.replace('_', ' ');
            component = new ComponentBuilder(ChatColor.translateAlternateColorCodes((char)'&', (String)s)).color(ChatColor.WHITE).bold(false).italic(false).create();
            cw.add(new BaseComponentWrapper(component));
        }
        return (ItemProvider)((ItemBuilder)((ItemBuilder)new ItemBuilder(Material.valueOf((String)this.rank.material.toUpperCase())).setDisplayName(new ComponentBuilder(this.rank.rankName).color(ChatColor.BLUE).create())).setLore(cw)).addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS, ItemFlag.HIDE_ATTRIBUTES});
    }

    public String convertPotionID(String potionID) {
        potionID = potionID.toLowerCase();
        this.plugin.getLogger().info(potionID);
        switch (potionID) {
            case "potion{potion:thick}": {
                return "Thick Potion";
            }
            case "splash_potion": {
                return "Splash Potion";
            }
            case "potion{potion:awkward}": {
                return "Awkward Potion";
            }
            case "potion{potion:mundane}": {
                return "Mundane Potion";
            }
            case "potion{potion:healing}": {
                return "Healing Potion";
            }
            case "potion{potion:harming}": {
                return "Harming Potion";
            }
            case "lingering_potion": {
                return "Lingering Potion";
            }
            case "potion{potion:strong_healing}": {
                return "Healing Potion II";
            }
            case "potion{potion:strong_harming}": {
                return "Harming Potion II";
            }
            case "potion{potion:empty}": {
                return "Uncraftable Potion";
            }
            case "potion{potion:poison}": {
                return "Poison Potion (0:45)";
            }
            case "potion{potion:long_poison}": {
                return "Poison Potion (2:00)";
            }
            case "potion{potion:leaping}": {
                return "Leaping Potion (3:00)";
            }
            case "splash_potion{potion:healing}": {
                return "Healing Splash Potion";
            }
            case "splash_potion{potion:harming}": {
                return "Harming Splash Potion";
            }
            case "potion{potion:weakness}": {
                return "Weakness Potion (1:30)";
            }
            case "potion{potion:strength}": {
                return "Strength Potion (3:00)";
            }
            case "potion{potion:slowness}": {
                return "Slowness Potion (1:30)";
            }
            case "potion{potion:strong_poison}": {
                return "Poison Potion II (0:22)";
            }
            case "potion{potion:long_weakness}": {
                return "Weakness Potion (4:00)";
            }
            case "potion{potion:long_strength}": {
                return "Strength Potion (8:00)";
            }
            case "potion{potion:long_slowness}": {
                return "Slowness Potion (4:00)";
            }
            case "potion{potion:swiftness}": {
                return "Swiftness Potion (3:00)";
            }
            case "potion{potion:strong_leaping}": {
                return "Leaping Potion II (1:30)";
            }
            case "potion{potion:long_swiftness}": {
                return "Swiftness Potion (8:00)";
            }
            case "splash_potion{potion:strong_healing}": {
                return "Healing II Splash Potion";
            }
            case "splash_potion{potion:strong_harming}": {
                return "Harming II Splash Potion";
            }
            case "potion{potion:strong_strength}": {
                return "Strength Potion II (1:30)";
            }
            case "potion{potion:night_vision}": {
                return "Night Vision Potion (3:00)";
            }
            case "potion{potion:strong_swiftness}": {
                return "Swiftness Potion II (1:30)";
            }
            case "potion{potion:long_night_vision}": {
                return "Night Vision Potion (8:00)";
            }
            case "potion{potion:invisibility}": {
                return "Invisibility Potion (3:00)";
            }
            case "potion{potion:long_regeneration}": {
                return "Regeneration Potion (1:30)";
            }
            case "potion{potion:long_invisibility}": {
                return "Invisibility Potion (8:00)";
            }
            case "splash_potion{potion:poison}": {
                return "Poison Splash (1:30) Potion";
            }
            case "potion{potion:slow_falling}": {
                return "Potion of Slow Falling (1:30)";
            }
            case "splash_potion{potion:leaping}": {
                return "Leaping Splash (3:00) Potion";
            }
            case "potion{potion:fire_resistance}": {
                return "Fire Resistance Potion (3:00)";
            }
            case "potion{potion:water_breathing}": {
                return "Water Breathing Potion (3:00)";
            }
            case "potion{potion:strong_regeneration}": {
                return "Regeneration Potion II (0:22)";
            }
            case "potion{potion:long_fire_resistance}": {
                return "Fire Resistance Potion (8:00)";
            }
            case "potion{potion:long_water_breathing}": {
                return "Water Breathing Potion (8:00)";
            }
        }
        return potionID;
    }

    @Override
    public void handleClick(@NotNull ClickType clickType, @NotNull Player player, @NotNull InventoryClickEvent event) {
        this.plugin.settings.ranks.rankClickEvent.clickedRank = this.rank;
        this.owned = this.plugin.settings.ranks.rankClickEvent.onRankGUIClick(event);
        this.notifyWindows();
    }

    public Integer getRankWeight() {
        return this.rank.weight;
    }

    @Override
    public int compareTo(@NotNull RankItem rank) {
        return this.getRankWeight().compareTo(rank.getRankWeight());
    }
}

