/*
 * Decompiled with CFR 0.152.
 */
package com.itsrainingplex.Ranks;

import com.itsrainingplex.RaindropQuests;
import com.itsrainingplex.Ranks.RankItem;
import de.studiocode.invui.gui.GUI;
import de.studiocode.invui.gui.impl.SimpleGUI;
import de.studiocode.invui.window.impl.single.SimpleWindow;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import org.bukkit.entity.Player;

public class RankGUI {
    private final RaindropQuests plugin;

    public RankGUI(RaindropQuests plugin) {
        this.plugin = plugin;
    }

    public void createRankGUI(Player player) {
        GUI gui;
        if (!this.plugin.settings.luckPerms) {
            if (this.plugin.settings.pm.getDebug()) {
                this.plugin.getLogger().warning("LuckPerms not found. Cancelling GUI...");
            }
            return;
        }
        Set<String> playerGroups = this.plugin.settings.ranks.lpm.getPlayerGroups(player);
        Collection<RankItem> ranksGUIItem = this.plugin.settings.ranks.ranksGUIItem.values();
        ArrayList<RankItem> rankItems = new ArrayList<RankItem>(ranksGUIItem);
        Comparator<RankItem> rankItemComparator = Comparator.comparing(RankItem::getRankWeight);
        rankItems.sort(rankItemComparator);
        for (RankItem r : rankItems) {
            Collection<String> c = this.plugin.settings.ranks.rankManager.get_Player_Groups(player);
            for (String s : c) {
                r.owned = r.rank.rankID.equalsIgnoreCase(s);
            }
        }
        if (this.plugin.settings.ranks.guiType.equalsIgnoreCase("Tab")) {
            ArrayList<GUI> guiList = new ArrayList<GUI>();
            for (int i = 1; i < 10; ++i) {
                SimpleGUI tempGUI = new SimpleGUI(9, 6);
                for (RankItem rankItem : rankItems) {
                    if (rankItem.rank.tier != i) continue;
                    if (playerGroups.contains(rankItem.rank.rankID.toLowerCase())) {
                        rankItem.owned = true;
                    }
                    tempGUI.addItems(rankItem);
                }
                guiList.add(tempGUI);
            }
            gui = this.plugin.settings.ranks.guiManager.getTabbedGUI(guiList);
        } else {
            gui = this.plugin.settings.ranks.guiType.equalsIgnoreCase("Scroll") ? this.plugin.settings.ranks.guiManager.getRankScrolledGUI(rankItems) : this.plugin.settings.ranks.guiManager.getRankPagedGUI(rankItems);
        }
        new SimpleWindow(player, this.plugin.settings.mainGUIMap.get((Object)"Ranks").name, gui).show();
    }
}

