/*
 * Decompiled with CFR 0.152.
 */
package com.itsrainingplex;

import com.itsrainingplex.Commands.CommandManager;
import com.itsrainingplex.Crafting.CraftSlices;
import com.itsrainingplex.Crafting.Dirt;
import com.itsrainingplex.Crafting.Dyes;
import com.itsrainingplex.Crafting.GoldenCraft;
import com.itsrainingplex.Crafting.IngotPassive;
import com.itsrainingplex.Crafting.NetherArmor;
import com.itsrainingplex.Crafting.NetherTools;
import com.itsrainingplex.Crafting.NetherWeapons;
import com.itsrainingplex.Crafting.Stone;
import com.itsrainingplex.Crafting.Transmog;
import com.itsrainingplex.Crafting.WheatSeedsGrown;
import com.itsrainingplex.Handlers.BlockHandler;
import com.itsrainingplex.Listeners.BlockEvents;
import com.itsrainingplex.Listeners.Crafting;
import com.itsrainingplex.Listeners.DeathManager;
import com.itsrainingplex.Listeners.MobManager;
import com.itsrainingplex.Listeners.MythicDeathManager;
import com.itsrainingplex.Listeners.PlayerInteract;
import com.itsrainingplex.Listeners.PlayerJoined;
import com.itsrainingplex.Listeners.Potions;
import com.itsrainingplex.MySQL.MySQL;
import com.itsrainingplex.MySQL.SQLGetter;
import com.itsrainingplex.SQLite.SQLite;
import com.itsrainingplex.Settings.Miscellaneous;
import com.itsrainingplex.Settings.RegisterCustomItems;
import com.itsrainingplex.Settings.Settings;
import com.itsrainingplex.Utilities.Metrics;
import com.itsrainingplex.Utilities.UpdateChecker;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.permissions.Permission;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public final class RaindropQuests
extends JavaPlugin {
    public Settings settings;
    public Miscellaneous misc;

    public void onEnable() {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this, this::start);
    }

    public void onDisable() {
        if (this.settings.pm.getDisable()) {
            this.getLogger().info("Stopping threads...");
        }
        if (this.settings.pm.getDisable()) {
            this.getLogger().info("Saving data and safe exiting...");
        }
        if (this.settings.dbType.equalsIgnoreCase("MySQL")) {
            this.settings.data.updateBlockData(this.settings.blockHandler.convertBlockData(this.settings.blocks));
            this.settings.sql.disconnect();
        } else {
            this.settings.db.updateBlockData(this.settings.blockHandler.convertBlockData(this.settings.blocks));
        }
        if (this.settings.pm.getDisable()) {
            this.getLogger().info("Disabling plugin...");
        }
    }

    public void start() {
        new Metrics(this, 16906);
        new UpdateChecker(this, 106370).getVersion(version -> {
            if (this.getDescription().getVersion().equals(version)) {
                this.getLogger().info("Plugin up-to-date.");
            } else if (this.getDescription().getVersion().compareToIgnoreCase((String)version) > 0) {
                this.getLogger().info("You are using a developer version: " + this.getDescription().getVersion() + " Stable version: " + version);
            } else {
                this.getLogger().info("Update available! Current version " + this.getDescription().getVersion() + " New version: " + version);
            }
        });
        this.misc = new Miscellaneous(this);
        this.saveDefaultConfig();
        this.settings = new Settings(this);
        this.settings.loadFiles();
        if (this.settings.pm.getDebug()) {
            this.getLogger().info("Configs loaded.");
        }
        if (this.settings.pm.getDebug()) {
            this.getLogger().info("Registering database...");
        }
        if (this.settings.dbType.equalsIgnoreCase("SQLite")) {
            if (this.settings.pm.getDebug()) {
                this.getLogger().info("Establishing connection to SQLite..");
            }
            this.settings.db = new SQLite(this);
            this.settings.db.load();
            if (this.settings.pm.getDebug()) {
                this.getLogger().info("SQLite database connected.");
            }
        }
        if (this.settings.dbType.equalsIgnoreCase("MySQL")) {
            if (this.settings.pm.getDebug()) {
                this.getLogger().info("Connecting to MySQL");
            }
            this.settings.sql = new MySQL(this.settings.mysql.get("hostname"), this.settings.mysql.get("port"), this.settings.mysql.get("username"), this.settings.mysql.get("password"), this.settings.mysql.get("database"), this.settings.mysql.get("useSSL"), this.settings.mysql.get("allowPublicKeyRetrieval"));
            this.settings.data = new SQLGetter(this);
            try {
                this.settings.sql.connect();
                if (this.settings.pm.getDebug()) {
                    this.getLogger().info("Connected to MySQL!");
                }
            }
            catch (ClassNotFoundException | SQLException e) {
                if (this.settings.pm.getDebug()) {
                    this.getLogger().info("Failed to establish connection to MySQL");
                }
                StringWriter errors = new StringWriter();
                e.printStackTrace(new PrintWriter(errors));
                this.getLogger().info(errors.toString());
            }
            if (this.settings.sql.isConnected()) {
                if (this.settings.pm.getDebug()) {
                    this.getLogger().info("Creating tables in MySQL database...");
                }
                this.settings.data.createTable();
                if (this.settings.pm.getDebug()) {
                    this.getLogger().info("Tables created in MySQL...");
                }
            }
        }
        if (this.settings.pm.getDebug()) {
            this.getLogger().info("Loading blocks from database...");
        }
        this.settings.blockHandler = new BlockHandler(this);
        this.misc.loadBlocks();
        if (this.settings.pm.getDebug()) {
            this.getLogger().info("Loading player kill data from database...");
        }
        if (this.settings.pm.getDebug()) {
            this.getLogger().info("Registering crafting recipes...");
        }
        this.settings.ingots = new IngotPassive(this);
        this.settings.ingots.registerIngotRecipes();
        this.settings.dirt = new Dirt(this);
        this.settings.dirt.registerDirtRecipes();
        this.settings.stone = new Stone(this);
        this.settings.stone.registerStoneRecipes();
        this.settings.transmog = new Transmog(this, 2);
        this.settings.transmog.registerTransmogRecipes();
        this.settings.netherTools = new NetherTools(this);
        this.settings.netherTools.registerCraftingRecipes();
        this.settings.netherWeapons = new NetherWeapons(this);
        this.settings.netherWeapons.registerCraftingRecipes();
        this.settings.netherArmor = new NetherArmor(this);
        this.settings.netherArmor.registerCraftingRecipes();
        this.settings.wsg = new WheatSeedsGrown(this);
        this.settings.wsg.registerRecipes();
        this.settings.dyes = new Dyes(this);
        if (this.settings.passives.get("Mixologist").primary()) {
            this.settings.dyes.registerPrimaries();
        }
        if (this.settings.passives.get("Mixologist").quasiPrimary()) {
            this.settings.dyes.registerQuasiPrimaries();
        }
        this.settings.goldenCraft = new GoldenCraft(this);
        this.settings.goldenCraft.registerGoldenApple();
        this.settings.goldenCraft.registerGoldenCarrot();
        this.settings.goldenCraft.registerEnchantedGoldenApple();
        if (this.settings.pm.getDebug()) {
            this.getLogger().info("Registering AutoMelons plugin...");
        }
        if (this.settings.autoMelonsConfig.craftEnabled() && this.settings.autoMelonsConfig.enabled()) {
            Bukkit.addRecipe((Recipe)new CraftSlices().slicesRecipe(this, new ItemStack(Material.MELON_SLICE, this.settings.autoMelonsConfig.amount())));
        }
        if (this.settings.pm.getDebug()) {
            this.getLogger().info("Registering custom items..");
        }
        this.settings.rci = new RegisterCustomItems(this);
        this.settings.rci.registerItems();
        if (this.settings.pm.getDebug()) {
            this.getLogger().info("Registering event listeners..");
        }
        if (this.settings.citizens) {
            this.getServer().getPluginManager().registerEvents((Listener)this.settings.npcManager, (Plugin)this);
        }
        if (this.settings.mythicMobs) {
            this.getServer().getPluginManager().registerEvents((Listener)new MythicDeathManager(this), (Plugin)this);
        }
        this.getServer().getPluginManager().registerEvents((Listener)new DeathManager(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new Crafting(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new Potions(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerInteract(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new BlockEvents(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerJoined(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new MobManager(this), (Plugin)this);
        if (this.settings.pm.getDebug()) {
            this.getLogger().info("Registering commands..");
        }
        Objects.requireNonNull(this.getCommand(this.settings.prefix)).setExecutor((CommandExecutor)new CommandManager(this));
        if (this.settings.pm.getDebug()) {
            this.getLogger().info("Registering permissions..");
        }
        PluginManager pm = this.getServer().getPluginManager();
        for (String s : this.settings.questNames) {
            pm.addPermission(new Permission("RaindropQuests.quests." + s));
            pm.addPermission(new Permission("RaindropQuests.command.quests." + s));
        }
        if (this.settings.pm.getDebug()) {
            this.getLogger().info("Plugin successfully loaded! Listening for events..");
        }
        Bukkit.getScheduler().runTaskTimer((Plugin)this, () -> {
            if (this.settings.sync) {
                this.misc.saveBlocks();
            }
        }, 0L, 20L * ((long)this.settings.interval * 60L));
    }
}

