/*
 * Decompiled with CFR 0.152.
 */
package com.itsrainingplex.Quests;

import com.itsrainingplex.Quests.Quest;
import com.itsrainingplex.RaindropQuests;
import de.studiocode.inventoryaccess.component.BaseComponentWrapper;
import de.studiocode.invui.item.ItemProvider;
import de.studiocode.invui.item.builder.ItemBuilder;
import de.studiocode.invui.item.impl.BaseItem;
import java.util.ArrayList;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemFlag;
import org.jetbrains.annotations.NotNull;

public class QuestItem
extends BaseItem
implements Comparable<QuestItem> {
    private final RaindropQuests plugin;
    public Quest quest;

    public QuestItem(RaindropQuests plugin, Quest quest) {
        this.plugin = plugin;
        this.quest = quest;
    }

    @Override
    public ItemProvider getItemProvider() {
        ArrayList<BaseComponentWrapper> cw = new ArrayList<BaseComponentWrapper>();
        for (String s : this.quest.getLore()) {
            BaseComponent[] component = new ComponentBuilder(ChatColor.translateAlternateColorCodes((char)'&', (String)s)).create();
            cw.add(new BaseComponentWrapper(component));
        }
        return (ItemProvider)((ItemBuilder)((ItemBuilder)new ItemBuilder(Material.valueOf((String)this.quest.getButton())).setDisplayName(new ComponentBuilder(ChatColor.translateAlternateColorCodes((char)'&', (String)this.quest.getName())).create())).setLore(cw)).addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS, ItemFlag.HIDE_ATTRIBUTES});
    }

    @Override
    public void handleClick(@NotNull ClickType clickType, @NotNull Player player, @NotNull InventoryClickEvent event) {
        if (player.hasPermission("RaindropQuests.quests." + this.quest.getName())) {
            if (this.plugin.settings.dbType.equalsIgnoreCase("SQLite")) {
                this.plugin.settings.questHandler.handleQuestSQLite(this.plugin, event, player, this.quest);
            } else {
                this.plugin.settings.questHandler.handleQuestMySQL(this.plugin, event, player, this.quest);
            }
            this.notifyWindows();
        }
    }

    public Integer getId() {
        return this.quest.getId();
    }

    @Override
    public int compareTo(@NotNull QuestItem questItem) {
        return this.getId().compareTo(questItem.getId());
    }
}

