/*
 * Decompiled with CFR 0.152.
 */
package com.itsrainingplex.Quests;

import com.itsrainingplex.Messages.QuestMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.bukkit.ChatColor;

public class Quest {
    private String name;
    private final String button;
    private List<String> lore;
    private final TreeMap<String, Integer> requirements;
    private final int currency;
    private final int vault;
    private final TreeMap<String, Integer> rewards;
    private boolean broadcast;
    public boolean discord;
    public boolean player;
    public boolean logger;
    public String completedMessage;
    private final int coolDown;
    private final int limit;
    private final String title;
    private final QuestMessage message;
    private final int id;

    public Quest(String name, int id, String title, String button, List<String> lore, TreeMap<String, Integer> requirements, int vault, int currency, TreeMap<String, Integer> rewards, boolean broadcast, boolean discord, boolean logger, boolean player, String completedMessage, int coolDown, int limit, QuestMessage message) {
        this.name = name;
        this.id = id;
        this.title = title;
        this.button = button;
        this.lore = lore;
        this.requirements = requirements;
        this.currency = currency;
        this.rewards = rewards;
        this.broadcast = broadcast;
        this.discord = discord;
        this.player = player;
        this.logger = logger;
        this.completedMessage = completedMessage;
        this.coolDown = coolDown;
        this.limit = limit;
        this.message = message;
        this.vault = vault;
    }

    public String toString() {
        return this.name + " | " + this.lore.toString() + " | " + this.requirements.toString() + " | " + this.currency + " | " + this.rewards.toString() + " | " + this.broadcast;
    }

    public int getId() {
        return this.id;
    }

    public int getVault() {
        return this.vault;
    }

    public String getTitle() {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.title);
    }

    public String getName() {
        return this.name;
    }

    public QuestMessage getMessage() {
        return this.message;
    }

    public String getButton() {
        return this.button;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getLore() {
        return this.translateList(this.lore);
    }

    public List<String> translateList(List<String> list) {
        ArrayList<String> temp = new ArrayList<String>();
        for (String s : list) {
            temp.add(ChatColor.translateAlternateColorCodes((char)'&', (String)s));
        }
        return temp;
    }

    public void setLore(List<String> lore) {
        this.lore = lore;
    }

    public TreeMap<String, Integer> getRequirements() {
        return this.requirements;
    }

    public int getCurrency() {
        return this.currency;
    }

    public TreeMap<String, Integer> getRewards() {
        return this.rewards;
    }

    public boolean getBroadcast() {
        return this.broadcast;
    }

    public void setBroadcast(boolean enabled) {
        this.broadcast = enabled;
    }

    public int getCoolDown() {
        return this.coolDown;
    }

    public int getLimit() {
        return this.limit;
    }
}

