/*
 * Decompiled with CFR 0.152.
 */
package com.itsrainingplex.MySQL;

import com.itsrainingplex.Block.Block;
import com.itsrainingplex.Counters.KillCount;
import com.itsrainingplex.RaindropQuests;
import com.itsrainingplex.SQLite.Database;
import com.itsrainingplex.SQLite.Errors;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class SQLGetter {
    private final RaindropQuests plugin;

    public SQLGetter(RaindropQuests plugin) {
        this.plugin = plugin;
    }

    public void createTable() {
        String tokensMainTable = "CREATE TABLE IF NOT EXISTS " + this.plugin.settings.mysql.get("main_table") + "(uuid VARCHAR(255) NOT NULL,player VARCHAR(255) NOT NULL,currency int NOT NULL,quests int NOT NULL,wood_passive int NOT NULL,iron_passive int NOT NULL,gold_passive int NOT NULL,diamond_passive int NOT NULL,nether_passive int NOT NULL,bonus_passive int NOT NULL,potion_return int NOT NULL,potion_extend int NOT NULL,potion_strength int NOT NULL,superheat int NOT NULL,transmogrification int NOT NULL,craftnethertools int NOT NULL,craftnetherweapons int NOT NULL,craftnetherarmor int NOT NULL,condense int NOT NULL,expedire int NOT NULL,mixologist int NOT NULL,transmutation int NOT NULL,passive18 int NOT NULL,passive19 int NOT NULL,PRIMARY KEY (uuid));";
        String tokensPassivesTable = "CREATE TABLE IF NOT EXISTS " + this.plugin.settings.mysql.get("passives_table") + "(uuid VARCHAR(255) NOT NULL,player VARCHAR(255) NOT NULL,wood_passive VARCHAR(255) NOT NULL,iron_passive VARCHAR(255) NOT NULL,gold_passive VARCHAR(255) NOT NULL,diamond_passive VARCHAR(255) NOT NULL,nether_passive VARCHAR(255) NOT NULL,bonus_passive VARCHAR(255) NOT NULL,potion_return VARCHAR(255) NOT NULL,potion_extend VARCHAR(255) NOT NULL,potion_strength VARCHAR(255) NOT NULL,superheat VARCHAR(255) NOT NULL,transmogrification VARCHAR(255) NOT NULL,craftnethertools VARCHAR(255) NOT NULL,craftnetherweapons VARCHAR(255) NOT NULL,craftnetherarmor VARCHAR(255) NOT NULL,condense VARCHAR(255) NOT NULL,expedire VARCHAR(255) NOT NULL,mixologist VARCHAR(255) NOT NULL,transmutation VARCHAR(255) NOT NULL,passive18 VARCHAR(255),passive19 VARCHAR(255),PRIMARY KEY (uuid));";
        StringBuilder tokensQuestsTable = new StringBuilder("CREATE TABLE IF NOT EXISTS " + this.plugin.settings.mysql.get("quests_table") + " (uuid VARCHAR(255) NOT NULL,player varchar(32) NOT NULL,");
        StringBuilder tokensDateTable = new StringBuilder("CREATE TABLE IF NOT EXISTS " + this.plugin.settings.mysql.get("date_table") + " (uuid VARCHAR(255) NOT NULL,player varchar(32) NOT NULL,");
        String blockData = "CREATE TABLE IF NOT EXISTS " + this.plugin.settings.mysql.get("blocks_table") + " (id int NOT NULL,blockdata varchar(1024) NOT NULL, PRIMARY KEY (id));";
        StringBuilder counterData = new StringBuilder("CREATE TABLE IF NOT EXISTS " + this.plugin.settings.mysql.get("counter_table") + " (uuid varchar(255) NOT NULL,");
        for (int i = 0; i < this.plugin.settings.numberOfQuests - 1; ++i) {
            tokensQuestsTable.append(this.plugin.settings.quests.get(i).getName()).append(" varchar(32) NOT NULL,");
            tokensDateTable.append(this.plugin.settings.quests.get(i).getName()).append(" varchar(32) NOT NULL,");
        }
        tokensQuestsTable.append(this.plugin.settings.quests.get(this.plugin.settings.numberOfQuests - 1).getName()).append(" varchar(32) NOT NULL,PRIMARY KEY (uuid));");
        tokensDateTable.append(this.plugin.settings.quests.get(this.plugin.settings.numberOfQuests - 1).getName()).append(" varchar(32) NOT NULL,PRIMARY KEY (uuid));");
        for (String s : this.plugin.settings.allMobTypes) {
            counterData.append(s).append(" int(7),");
        }
        counterData.append("PRIMARY KEY (uuid));");
        try (PreparedStatement ps = this.plugin.settings.sql.getConnection().prepareStatement(tokensMainTable);
             PreparedStatement ps2 = this.plugin.settings.sql.getConnection().prepareStatement(tokensQuestsTable.toString());
             PreparedStatement ps3 = this.plugin.settings.sql.getConnection().prepareStatement(tokensDateTable.toString());
             PreparedStatement ps4 = this.plugin.settings.sql.getConnection().prepareStatement(blockData);
             PreparedStatement ps5 = this.plugin.settings.sql.getConnection().prepareStatement(tokensPassivesTable);
             PreparedStatement ps6 = this.plugin.settings.sql.getConnection().prepareStatement(counterData.toString());){
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info("Running query: " + ps.toString());
                this.plugin.getLogger().info("Running query: " + ps2.toString());
                this.plugin.getLogger().info("Running query: " + ps3.toString());
                this.plugin.getLogger().info("Running query: " + ps4.toString());
                this.plugin.getLogger().info("Running query: " + ps5.toString());
                this.plugin.getLogger().info("Running query: " + ps6.toString());
            }
            ps.executeUpdate();
            ps2.executeUpdate();
            ps3.executeUpdate();
            ps4.executeUpdate();
            ps5.executeUpdate();
            ps6.executeUpdate();
        }
        catch (SQLException e) {
            StringWriter errors = new StringWriter();
            e.printStackTrace(new PrintWriter(errors));
            Bukkit.getLogger().warning(errors.toString());
        }
    }

    public Integer getCurrency(String uuid) {
        try {
            Connection conn = this.plugin.settings.sql.getConnection();
            PreparedStatement ps = conn.prepareStatement("SELECT * FROM " + this.plugin.settings.mysql.get("main_table") + " WHERE uuid = '" + uuid + "';");
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info("Running query: " + ps.toString());
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                if (!rs.getString("uuid").equals(uuid)) continue;
                return rs.getInt("currency");
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        return 0;
    }

    public boolean isPlayer(String uuid, String table) {
        try {
            Connection conn = this.plugin.settings.sql.getConnection();
            PreparedStatement ps = conn.prepareStatement("SELECT * FROM " + table + " WHERE uuid = '" + uuid + "';");
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info("Running query: " + ps.toString());
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                if (!rs.getString("uuid").equals(uuid)) continue;
                return true;
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        return false;
    }

    public Integer getQuests(String uuid) {
        try {
            Connection conn = this.plugin.settings.sql.getConnection();
            PreparedStatement ps = conn.prepareStatement("SELECT * FROM " + this.plugin.settings.mysql.get("main_table") + " WHERE uuid = '" + uuid + "';");
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info("Running query: " + ps.toString());
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                if (!rs.getString("uuid").equals(uuid)) continue;
                return rs.getInt("quests");
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        return 0;
    }

    public String getQuestTime(String uuid, String quest) {
        return this.getQuest(uuid, quest, this.plugin.settings.mysql.get("quests_table"));
    }

    public String getPassiveTime(String uuid, String passive) {
        return this.getQuest(uuid, passive, this.plugin.settings.mysql.get("passives_table"));
    }

    public String getQuestTally(String uuid, String quest) {
        return this.getQuest(uuid, quest, this.plugin.settings.mysql.get("quests_table"));
    }

    private String getQuest(String uuid, String quest, String table) {
        try {
            Connection conn = this.plugin.settings.sql.getConnection();
            PreparedStatement ps = conn.prepareStatement("SELECT * FROM " + table + " WHERE uuid = '" + uuid + "';");
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info("Running query: " + ps.toString());
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                if (!rs.getString("uuid").equals(uuid)) continue;
                return rs.getString(quest);
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        return "0";
    }

    public void setDateTable(Player player, String[] str) {
        this.setTable(player, str, this.plugin.settings.mysql.get("date_table"));
    }

    public void setQuestsTable(Player player, String[] str) {
        this.setTable(player, str, this.plugin.settings.mysql.get("quests_table"));
    }

    private void setTable(Player player, String[] str, String table) {
        try {
            Connection conn = this.plugin.settings.sql.getConnection();
            String statement = "REPLACE INTO " + table + " (player,uuid,";
            PreparedStatement ps = SQLGetter.getPreparedStatementQuest(conn, statement, this.plugin);
            this.setupStatement(player, str, ps);
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
    }

    private void runPassiveSet(Player player, String[] str, String table) {
        try {
            Connection conn = this.plugin.settings.sql.getConnection();
            String statement = "REPLACE INTO " + table + " (player,uuid,";
            PreparedStatement ps = SQLGetter.getPreparedStatementPassive(conn, statement, this.plugin);
            ps.setString(21, "0");
            ps.setString(22, "0");
            this.setupStatement(player, str, ps);
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
    }

    private void setupStatement(Player player, String[] str, PreparedStatement ps) throws SQLException {
        ps.setString(1, player.getName().toLowerCase());
        ps.setString(2, player.getUniqueId().toString());
        for (int i = 3; i < str.length + 3; ++i) {
            ps.setString(i, str[i - 3]);
        }
        if (this.plugin.settings.pm.getExtendedDebug()) {
            this.plugin.getLogger().info("Running query: " + ps);
        }
        ps.executeUpdate();
    }

    public static PreparedStatement getPreparedStatementQuest(Connection conn, String statement, RaindropQuests plugin) throws SQLException {
        StringBuilder statementBuilder = new StringBuilder((String)statement);
        for (int i = 0; i < plugin.settings.numberOfQuests - 1; ++i) {
            statementBuilder.append(plugin.settings.quests.get(i).getName()).append(",");
        }
        statement = statementBuilder.toString();
        statement = (String)statement + plugin.settings.quests.get(plugin.settings.numberOfQuests - 1).getName() + ") VALUES(?,?,";
        statement = (String)statement + "?,".repeat(Math.max(0, plugin.settings.numberOfQuests - 1));
        statement = (String)statement + "?)";
        PreparedStatement ps = conn.prepareStatement((String)statement);
        return ps;
    }

    public static PreparedStatement getPreparedStatementPassive(Connection conn, String statement, RaindropQuests plugin) throws SQLException {
        StringBuilder statementBuilder = new StringBuilder((String)statement);
        for (String st : plugin.settings.passiveNames) {
            statementBuilder.append(st).append(",");
        }
        statement = statementBuilder.toString();
        statement = (String)statement + "passive18,passive19";
        statement = (String)statement + ") VALUES(?,?,";
        statement = (String)statement + "?,".repeat(plugin.settings.passiveNames.size());
        statement = (String)statement + "?,?)";
        PreparedStatement ps = conn.prepareStatement((String)statement);
        return ps;
    }

    public void addPlayerToCounterTable(Player player) {
        try {
            Connection conn = this.plugin.settings.sql.getConnection();
            StringBuilder statement = new StringBuilder("REPLACE INTO " + this.plugin.settings.mysql.get("counter_table") + " (uuid,playerkills,");
            for (String s : this.plugin.settings.allMobTypes) {
                statement.append(s).append(",");
            }
            statement = new StringBuilder(statement.substring(0, statement.length() - 1));
            statement.append(") VALUES(\"").append(player.getUniqueId()).append("\",");
            statement.append("0,");
            statement.append("0,".repeat(this.plugin.settings.allMobTypes.size()));
            statement = new StringBuilder(statement.substring(0, statement.length() - 1));
            statement.append(")");
            this.plugin.getLogger().info(statement.toString());
            PreparedStatement ps = conn.prepareStatement(statement.toString());
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
    }

    public void setPassive(Player player, String passive, Integer value) {
        try {
            Connection conn = this.plugin.settings.sql.getConnection();
            PreparedStatement ps = conn.prepareStatement("UPDATE " + this.plugin.settings.mysql.get("main_table") + " set " + passive + "=? WHERE uuid=?");
            ps.setInt(1, value);
            ps.setString(2, player.getUniqueId().toString());
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info("Running query: " + ps);
            }
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
    }

    public void setCurrency(Player player, Integer value) {
        try {
            Connection conn = this.plugin.settings.sql.getConnection();
            PreparedStatement ps = conn.prepareStatement("UPDATE " + this.plugin.settings.mysql.get("main_table") + " set currency=? WHERE uuid=?");
            ps.setInt(1, value);
            ps.setString(2, player.getUniqueId().toString());
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info("Running query: " + ps);
            }
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
    }

    public void setPassivesTable(Player player, String[] str) {
        this.runPassiveSet(player, str, this.plugin.settings.mysql.get("passives_table"));
    }

    public Integer getPassiveStatus(Player player, String passive) {
        try {
            ResultSet rs;
            Connection conn = this.plugin.settings.sql.getConnection();
            PreparedStatement ps = conn.prepareStatement("SELECT " + passive.toLowerCase() + " FROM " + this.plugin.settings.mysql.get("main_table") + " WHERE uuid = ?");
            ps.setString(1, player.getUniqueId().toString());
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info("Running query: " + ps);
            }
            if ((rs = ps.executeQuery()).next()) {
                return rs.getInt(passive);
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        return null;
    }

    public ArrayList<String> getAllPlayers() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            Connection conn = this.plugin.settings.sql.getConnection();
            PreparedStatement ps = conn.prepareStatement("SELECT uuid FROM " + this.plugin.settings.mysql.get("main_table"));
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                list.add(rs.getString("uuid"));
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        return list;
    }

    public void updateBlockData(ArrayList<String> data) {
        PreparedStatement ps;
        Connection conn;
        Database.messageBlockUpdate(data, this.plugin);
        try {
            conn = this.plugin.settings.sql.getConnection();
            ps = conn.prepareStatement("TRUNCATE TABLE " + this.plugin.settings.mysql.get("blocks_table"));
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info("Running query: " + ps);
            }
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        for (int i = 0; i < data.size(); ++i) {
            String s = data.get(i);
            try {
                conn = this.plugin.settings.sql.getConnection();
                ps = conn.prepareStatement("REPLACE INTO " + this.plugin.settings.mysql.get("blocks_table") + "(id,blockdata) VALUES(?,?)");
                ps.setInt(1, i);
                ps.setString(2, s);
                if (this.plugin.settings.pm.getExtendedDebug()) {
                    this.plugin.getLogger().info("Running query: " + ps);
                }
                ps.executeUpdate();
                continue;
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
            }
        }
    }

    public void setKillCount(String uuid, String mob, Integer amount) {
        if (amount == null) {
            return;
        }
        try {
            Connection conn = this.plugin.settings.sql.getConnection();
            PreparedStatement ps = conn.prepareStatement("UPDATE " + this.plugin.settings.mysql.get("counter_table") + " SET " + mob + "=" + amount + " WHERE uuid=?");
            ps.setString(1, uuid);
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info("Running query: " + ps);
            }
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
    }

    @Deprecated
    public void loadAllKillData() {
        try {
            Connection conn = this.plugin.settings.sql.getConnection();
            PreparedStatement ps = conn.prepareStatement("SELECT * FROM " + this.plugin.settings.mysql.get("counter_table") + ";");
            SQLGetter.runKillDataFromLoad(ps, this.plugin);
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
    }

    @Deprecated
    public static void runKillDataFromLoad(PreparedStatement ps, RaindropQuests plugin) throws SQLException {
        if (plugin.settings.pm.getExtendedDebug()) {
            plugin.getLogger().info("Running query: " + ps.toString());
        }
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            UUID id = UUID.fromString(rs.getString("uuid"));
            KillCount kc = new KillCount(plugin, id);
            for (String s : plugin.settings.mythicMobTypes) {
                kc.mythicMobKills.put(s, rs.getInt(s));
            }
            for (String s : plugin.settings.vanillaMobsTypes) {
                kc.vanillaMobKills.put(s, rs.getInt(s));
            }
            plugin.settings.playerKills.put(id, kc);
        }
    }

    public int getKillCount(String uuid, String entity) {
        try {
            Connection conn = this.plugin.settings.sql.getConnection();
            PreparedStatement ps = conn.prepareStatement("SELECT * FROM " + this.plugin.settings.mysql.get("counter_table") + " WHERE uuid = '" + uuid + "';");
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info("Running query: " + ps.toString());
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                if (!rs.getString("uuid").equalsIgnoreCase(uuid)) continue;
                return rs.getInt(entity);
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        return 0;
    }

    public ArrayList<Block> getBlockData() {
        ArrayList<String> temp = new ArrayList<String>();
        try {
            Connection conn = this.plugin.settings.sql.getConnection();
            PreparedStatement ps = conn.prepareStatement("SELECT * FROM " + this.plugin.settings.mysql.get("blocks_table") + ";");
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info("Running query: " + ps);
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                temp.add(rs.getString("blockdata"));
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        if (this.plugin.settings.pm.getExtendedDebug()) {
            this.plugin.getLogger().info(temp.toString());
        }
        return this.plugin.settings.blockHandler.loadBlockData(temp);
    }

    public void setMainTable(Player player, Integer currency, Integer quests, Integer wood_passive, Integer iron_passive, Integer gold_passive, Integer diamond_passive, Integer nether_passive, Integer bonus_passive, Integer potion_return, Integer potion_extend, Integer potion_strength, Integer superheat, Integer transmog, Integer CraftNetherTools, Integer CraftNetherWeapons, Integer CraftNetherArmor, Integer condense, Integer expedire, Integer mixologist, Integer transmutation, Integer passive18, Integer passive19) {
        try {
            Connection conn = this.plugin.settings.sql.getConnection();
            PreparedStatement ps = conn.prepareStatement("REPLACE INTO " + this.plugin.settings.mysql.get("main_table") + "(uuid,player,currency,quests,wood_passive,iron_passive,gold_passive,diamond_passive,nether_passive,bonus_passive,potion_return,potion_extend,potion_strength,superheat,transmogrification,craftnethertools,craftnetherweapons,craftnetherarmor,condense,expedire,mixologist,transmutation,passive18,passive19) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            SQLGetter.setupPreparedStatement(player, currency, quests, wood_passive, iron_passive, gold_passive, diamond_passive, nether_passive, bonus_passive, potion_return, potion_extend, potion_strength, superheat, transmog, CraftNetherTools, CraftNetherWeapons, CraftNetherArmor, condense, expedire, mixologist, transmutation, passive18, passive19, ps);
            if (this.plugin.settings.pm.getExtendedDebug()) {
                this.plugin.getLogger().info("Running query: " + ps);
            }
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
    }

    public static void setupPreparedStatement(Player player, Integer currency, Integer quests, Integer wood_passive, Integer iron_passive, Integer gold_passive, Integer diamond_passive, Integer nether_passive, Integer bonus_passive, Integer potion_return, Integer potion_extend, Integer potion_strength, Integer superheat, Integer transmog, Integer CraftNetherTools, Integer CraftNetherWeapons, Integer CraftNetherArmor, Integer condense, Integer expedire, Integer mixologist, Integer transmutation, Integer passive18, Integer passive19, PreparedStatement ps) throws SQLException {
        ps.setString(1, player.getUniqueId().toString());
        ps.setString(2, player.getName().toLowerCase());
        ps.setInt(3, currency);
        ps.setInt(4, quests);
        ps.setInt(5, wood_passive);
        ps.setInt(6, iron_passive);
        ps.setInt(7, gold_passive);
        ps.setInt(8, diamond_passive);
        ps.setInt(9, nether_passive);
        ps.setInt(10, bonus_passive);
        ps.setInt(11, potion_return);
        ps.setInt(12, potion_extend);
        ps.setInt(13, potion_strength);
        ps.setInt(14, superheat);
        ps.setInt(15, transmog);
        ps.setInt(16, CraftNetherTools);
        ps.setInt(17, CraftNetherWeapons);
        ps.setInt(18, CraftNetherArmor);
        ps.setInt(19, condense);
        ps.setInt(20, expedire);
        ps.setInt(21, mixologist);
        ps.setInt(22, transmutation);
        ps.setInt(23, passive18);
        ps.setInt(24, passive19);
    }
}

