/*
 * Decompiled with CFR 0.152.
 */
package com.itsrainingplex.LuckPerms;

import com.itsrainingplex.LuckPerms.PrefixItem;
import com.itsrainingplex.RaindropQuests;
import com.itsrainingplex.Ranks.Rank;
import de.studiocode.invui.gui.GUI;
import de.studiocode.invui.gui.impl.SimpleGUI;
import de.studiocode.invui.window.impl.single.SimpleWindow;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.bukkit.entity.Player;

public class PrefixManager {
    private final RaindropQuests plugin;

    public PrefixManager(RaindropQuests plugin) {
        this.plugin = plugin;
    }

    public void createPrefixGUI(Player player) {
        GUI gui;
        if (!this.plugin.settings.luckPerms) {
            if (this.plugin.settings.pm.getDebug()) {
                this.plugin.getLogger().warning("LuckPerms not found. Cancelling GUI...");
            }
            return;
        }
        ArrayList<String> playerPrefixes = this.getPlayerPrefixes(player);
        Collection<PrefixItem> prefixesGUIItems = this.plugin.settings.ranks.prefixGUIItem.values();
        ArrayList<PrefixItem> prefixItems = new ArrayList<PrefixItem>(prefixesGUIItems);
        ArrayList<PrefixItem> playerPrefixItems = new ArrayList<PrefixItem>();
        for (PrefixItem item : prefixItems) {
            for (String s : playerPrefixes) {
                if (!item.rank.prefix.equalsIgnoreCase(s)) continue;
                playerPrefixItems.add(item);
            }
        }
        if (this.plugin.settings.ranks.guiType.equalsIgnoreCase("Tab")) {
            ArrayList<GUI> guiList = new ArrayList<GUI>();
            for (int i = 1; i < 10; ++i) {
                SimpleGUI tempGUI = new SimpleGUI(9, 6);
                for (PrefixItem prefixItem : playerPrefixItems) {
                    if (prefixItem.rank.tier != i) continue;
                    tempGUI.addItems(prefixItem);
                }
                if (this.plugin.settings.towny && i == this.plugin.settings.ranks.townyPrefixTab && this.plugin.settings.ranks.townyPrefix) {
                    Rank rank;
                    Object str;
                    if (this.plugin.settings.towny && this.plugin.settings.ranks.townyManager.checkKing(player)) {
                        str = this.plugin.settings.ranks.nationNamePrefix ? this.plugin.settings.ranks.townyManager.getKingName(player) + " of " + this.plugin.settings.ranks.townyManager.getNationName(player) : this.plugin.settings.ranks.townyManager.getKingName(player);
                        rank = new Rank(this.plugin.settings.ranks.townyManager.getKingName(player), this.plugin.settings.ranks.townPrefixMaterial, "Towny", null, null, null, null, null, "Towny", (String)str, (String)str, null, -1, 8, null);
                        tempGUI.addItems(new PrefixItem(this.plugin, rank));
                    } else if (this.plugin.settings.towny && !this.plugin.settings.ranks.townyManager.getNationRank(player).isBlank()) {
                        str = this.plugin.settings.ranks.nationNamePrefix ? this.plugin.settings.ranks.townyManager.getNationRank(player) + " of " + this.plugin.settings.ranks.townyManager.getNationName(player) : this.plugin.settings.ranks.townyManager.getNationRank(player);
                        rank = new Rank(this.plugin.settings.ranks.townyManager.getNationRank(player), this.plugin.settings.ranks.townPrefixMaterial, "Towny", null, null, null, null, null, "Towny", (String)str, (String)str, null, -1, 8, null);
                        tempGUI.addItems(new PrefixItem(this.plugin, rank));
                    }
                    if (this.plugin.settings.towny && this.plugin.settings.ranks.townyManager.checkMayor(player)) {
                        str = this.plugin.settings.ranks.townNamePrefix ? this.plugin.settings.ranks.townyManager.getMayorName(player) + " of " + this.plugin.settings.ranks.townyManager.getTownName(player) : this.plugin.settings.ranks.townyManager.getMayorName(player);
                        rank = new Rank(this.plugin.settings.ranks.townyManager.getMayorName(player), this.plugin.settings.ranks.townPrefixMaterial, "Towny", null, null, null, null, null, "Towny", (String)str, (String)str, null, -1, 8, null);
                        tempGUI.addItems(new PrefixItem(this.plugin, rank));
                    } else if (this.plugin.settings.towny && !this.plugin.settings.ranks.townyManager.getTownRank(player).isBlank()) {
                        str = this.plugin.settings.ranks.townNamePrefix ? this.plugin.settings.ranks.townyManager.getTownName(player) + " of " + this.plugin.settings.ranks.townyManager.getTownRank(player) : this.plugin.settings.ranks.townyManager.getTownRank(player);
                        rank = new Rank(this.plugin.settings.ranks.townyManager.getTownRank(player), this.plugin.settings.ranks.townPrefixMaterial, "Towny", null, null, null, null, null, "Towny", (String)str, (String)str, null, -1, 8, null);
                        tempGUI.addItems(new PrefixItem(this.plugin, rank));
                    }
                }
                guiList.add(tempGUI);
            }
            gui = this.plugin.settings.ranks.guiManager.getTabbedGUI(guiList);
        } else if (this.plugin.settings.ranks.guiType.equalsIgnoreCase("Scroll")) {
            gui = this.plugin.settings.ranks.guiManager.getPrefixScrolledGUI(this.createTownyPrefixItem(player, playerPrefixItems));
        } else {
            this.createTownyPrefixItem(player, playerPrefixItems);
            gui = this.plugin.settings.ranks.guiManager.getPrefixPagedGUI(this.createTownyPrefixItem(player, playerPrefixItems));
        }
        new SimpleWindow(player, "Prefix Menu", gui).show();
    }

    private List<PrefixItem> createTownyPrefixItem(Player player, List<PrefixItem> playerPrefixItems) {
        if (!this.plugin.settings.towny) {
            return playerPrefixItems;
        }
        if (this.plugin.settings.ranks.townyPrefix) {
            Rank rank;
            Object str;
            if (this.plugin.settings.towny && this.plugin.settings.ranks.townyManager.checkKing(player)) {
                str = this.plugin.settings.ranks.nationNamePrefix ? this.plugin.settings.ranks.townyManager.getKingName(player) + " of " + this.plugin.settings.ranks.townyManager.getNationName(player) : this.plugin.settings.ranks.townyManager.getKingName(player);
                rank = new Rank(this.plugin.settings.ranks.townyManager.getKingName(player), this.plugin.settings.ranks.townPrefixMaterial, "Towny", null, null, null, null, null, "Towny", (String)str, (String)str, null, -1, 8, null);
                playerPrefixItems.add(new PrefixItem(this.plugin, rank));
            } else if (this.plugin.settings.towny && !this.plugin.settings.ranks.townyManager.getNationRank(player).isBlank()) {
                str = this.plugin.settings.ranks.nationNamePrefix ? this.plugin.settings.ranks.townyManager.getNationRank(player) + " of " + this.plugin.settings.ranks.townyManager.getNationName(player) : this.plugin.settings.ranks.townyManager.getNationRank(player);
                rank = new Rank(this.plugin.settings.ranks.townyManager.getNationRank(player), this.plugin.settings.ranks.townPrefixMaterial, "Towny", null, null, null, null, null, "Towny", (String)str, (String)str, null, -1, 8, null);
                playerPrefixItems.add(new PrefixItem(this.plugin, rank));
            }
            if (this.plugin.settings.towny && this.plugin.settings.ranks.townyManager.checkMayor(player)) {
                str = this.plugin.settings.ranks.townNamePrefix ? this.plugin.settings.ranks.townyManager.getMayorName(player) + " of " + this.plugin.settings.ranks.townyManager.getTownName(player) : this.plugin.settings.ranks.townyManager.getMayorName(player);
                rank = new Rank(this.plugin.settings.ranks.townyManager.getMayorName(player), this.plugin.settings.ranks.townPrefixMaterial, "Towny", null, null, null, null, null, "Towny", (String)str, (String)str, null, -1, 8, null);
                playerPrefixItems.add(new PrefixItem(this.plugin, rank));
            } else if (this.plugin.settings.towny && !this.plugin.settings.ranks.townyManager.getTownRank(player).isBlank()) {
                str = this.plugin.settings.ranks.townNamePrefix ? this.plugin.settings.ranks.townyManager.getTownRank(player) + " of " + this.plugin.settings.ranks.townyManager.getTownName(player) : this.plugin.settings.ranks.townyManager.getTownRank(player);
                rank = new Rank(this.plugin.settings.ranks.townyManager.getTownRank(player), this.plugin.settings.ranks.townPrefixMaterial, "Towny", null, null, null, null, null, "Towny", (String)str, (String)str, null, -1, 8, null);
                playerPrefixItems.add(new PrefixItem(this.plugin, rank));
            }
        }
        return playerPrefixItems;
    }

    public ArrayList<String> getPlayerPrefixes(Player player) {
        Set<String> groups = this.plugin.settings.ranks.lpm.getPlayerGroups(player);
        ArrayList<String> prefixes = new ArrayList<String>();
        for (String s : groups) {
            for (Rank rank : this.plugin.settings.ranks.ranks.values()) {
                if (!rank.rankID.equalsIgnoreCase(s.toLowerCase())) continue;
                prefixes.add(rank.prefix);
            }
            for (Rank altRank : this.plugin.settings.ranks.altRanks.values()) {
                if (!altRank.rankID.equalsIgnoreCase(s.toLowerCase())) continue;
                prefixes.add(altRank.prefix);
            }
        }
        prefixes.remove("None");
        prefixes.remove("none");
        prefixes = this.removeDuplicates(prefixes);
        return prefixes;
    }

    public <T> ArrayList<T> removeDuplicates(ArrayList<T> list) {
        ArrayList<T> newList = new ArrayList<T>();
        for (T element : list) {
            if (newList.contains(element)) continue;
            newList.add(element);
        }
        return newList;
    }
}

