/*
 * Decompiled with CFR 0.152.
 */
package com.itsrainingplex.EliteModSummons;

import com.itsrainingplex.RaindropQuests;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;

public class EMSSettings {
    private final RaindropQuests plugin;
    public List<String> support = new ArrayList<String>();
    public List<String> mods = new ArrayList<String>();
    public HashMap<String, String> messages = new HashMap();
    public String tp;
    private final File emsDir;
    public FileConfiguration config;
    public boolean enabled;

    public EMSSettings(@NotNull RaindropQuests plugin) {
        this.plugin = plugin;
        this.emsDir = new File(plugin.getDataFolder() + File.separator + "EliteModSummons");
        this.loadFiles();
    }

    public void loadFiles() {
        this.loadConfig();
        this.tp = this.config.getString("Command.tp");
        if (this.enabled) {
            this.enabled = this.config.getBoolean("Enabled");
        } else {
            this.plugin.getLogger().info("EliteModSummons folder not found in plugins folder!");
        }
        File modsFile = new File(this.plugin.getDataFolder(), "EliteModSummons" + File.separator + "staff.yml");
        if (!modsFile.exists()) {
            this.plugin.saveResource("EliteModSummons" + File.separator + "staff.yml", false);
        }
        YamlConfiguration modsConfig = YamlConfiguration.loadConfiguration((File)modsFile);
        this.mods = modsConfig.getStringList("Mods");
        this.support = modsConfig.getStringList("Support");
        File messagesFile = new File(this.plugin.getDataFolder(), "EliteModSummons" + File.separator + "messages.yml");
        if (!messagesFile.exists()) {
            this.plugin.saveResource("EliteModSummons" + File.separator + "messages.yml", false);
        }
        YamlConfiguration messagesConfig = YamlConfiguration.loadConfiguration((File)messagesFile);
        this.messages.put("CallMod.Support", messagesConfig.getString("CallMod.Support"));
        this.messages.put("CallMod.Mod", messagesConfig.getString("CallMod.Mod"));
        this.messages.put("CallMod.Discord", messagesConfig.getString("CallMod.Discord"));
        this.messages.put("CallMod.NotifyRoleID", messagesConfig.getString("CallMod.NotifyRoleID"));
        this.messages.put("EMS.Support", messagesConfig.getString("EMS.Support"));
        this.messages.put("EMS.Mod", messagesConfig.getString("EMS.Mod"));
        this.messages.put("EMS.Discord", messagesConfig.getString("EMS.Discord"));
        this.messages.put("EMS.NotifyRoleID", messagesConfig.getString("EMS.NotifyRoleID"));
    }

    public void loadConfig() {
        File ranksConfigFile;
        if (!this.emsDir.exists()) {
            this.enabled = this.emsDir.mkdir();
        }
        if (!(ranksConfigFile = new File(this.plugin.getDataFolder(), "EliteModSummons" + File.separator + "config.yml")).exists()) {
            this.plugin.saveResource("EliteModSummons" + File.separator + "config.yml", false);
        }
        this.config = YamlConfiguration.loadConfiguration((File)ranksConfigFile);
    }
}

