/*
 * Decompiled with CFR 0.152.
 */
package com.itsrainingplex.Crafting;

import com.itsrainingplex.RaindropQuests;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class IngotPassive {
    private final RaindropQuests plugin;
    private final int ironOreCost;
    private final int goldOreCost;
    private final int copperOreCost;

    public IngotPassive(@NotNull RaindropQuests plugin) {
        this.plugin = plugin;
        int[] i = plugin.settings.getPassive("superheat").oreCost();
        this.ironOreCost = i[0];
        this.goldOreCost = i[1];
        this.copperOreCost = i[2];
    }

    public void registerIngotRecipes() {
        int i;
        ItemStack ironItem = new ItemStack(Material.IRON_INGOT);
        ItemStack goldItem = new ItemStack(Material.GOLD_INGOT);
        ItemStack copperItem = new ItemStack(Material.COPPER_INGOT);
        NamespacedKey ironKey = new NamespacedKey((Plugin)this.plugin, "raindropiron");
        ShapelessRecipe ironRecipe = new ShapelessRecipe(ironKey, ironItem);
        NamespacedKey goldKey = new NamespacedKey((Plugin)this.plugin, "raindropgold");
        ShapelessRecipe goldRecipe = new ShapelessRecipe(goldKey, goldItem);
        NamespacedKey copperKey = new NamespacedKey((Plugin)this.plugin, "raindropcopper");
        ShapelessRecipe copperRecipe = new ShapelessRecipe(copperKey, copperItem);
        ItemMeta ironMeta = ironItem.getItemMeta();
        ItemMeta goldMeta = goldItem.getItemMeta();
        ItemMeta copperMeta = copperItem.getItemMeta();
        assert (ironMeta != null);
        PersistentDataContainer iron = ironMeta.getPersistentDataContainer();
        iron.set(new NamespacedKey((Plugin)this.plugin, "ID"), PersistentDataType.STRING, (Object)"iron");
        assert (goldMeta != null);
        PersistentDataContainer gold = goldMeta.getPersistentDataContainer();
        gold.set(new NamespacedKey((Plugin)this.plugin, "ID"), PersistentDataType.STRING, (Object)"gold");
        assert (copperMeta != null);
        PersistentDataContainer copper = copperMeta.getPersistentDataContainer();
        copper.set(new NamespacedKey((Plugin)this.plugin, "ID"), PersistentDataType.STRING, (Object)"copper");
        for (i = 0; i < this.ironOreCost; ++i) {
            ironRecipe.addIngredient(Material.IRON_ORE);
        }
        for (i = 0; i < this.goldOreCost; ++i) {
            goldRecipe.addIngredient(Material.GOLD_ORE);
        }
        for (i = 0; i < this.copperOreCost; ++i) {
            copperRecipe.addIngredient(Material.COPPER_ORE);
        }
        Bukkit.addRecipe((Recipe)ironRecipe);
        Bukkit.addRecipe((Recipe)goldRecipe);
        Bukkit.addRecipe((Recipe)copperRecipe);
    }
}

