/*
 * Decompiled with CFR 0.152.
 */
package com.itsrainingplex.Commands.RaindropQuests;

import com.itsrainingplex.Commands.SubCommand;
import com.itsrainingplex.RaindropQuests;
import java.util.List;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class Quest
extends SubCommand {
    private final RaindropQuests plugin;

    public Quest(RaindropQuests plugin) {
        this.plugin = plugin;
    }

    @Override
    public String getName() {
        return "quest";
    }

    @Override
    public String getDescription() {
        return "Quest command";
    }

    @Override
    public String getSyntax() {
        return "/" + this.plugin.settings.prefix + " quest <QuestName>";
    }

    @Override
    public void perform(Player player, String @NotNull [] args) {
        if (args.length == 2 && player.hasPermission("RaindropQuests.command.quests." + args[1]) && !this.isInt(args[1])) {
            int i = 0;
            for (String s : this.plugin.settings.questNames) {
                if (args[1].equalsIgnoreCase(s)) {
                    BaseComponent[] component = new ComponentBuilder("//////////////////").append(this.plugin.settings.quests.get(i).getTitle()).append("&f\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\").create();
                    player.spigot().sendMessage(component);
                    List<String> str = this.plugin.settings.quests.get(i).getLore();
                    for (String st : str) {
                        component = new ComponentBuilder(this.plugin.misc.translateText(this.plugin.misc.translateText(st))).create();
                        player.spigot().sendMessage(component);
                    }
                    if (this.plugin.settings.quests.get(i).getLimit() != -1) {
                        component = new ComponentBuilder("&fQuest Completion Limit: ").append(this.plugin.misc.translateText(String.valueOf(this.plugin.settings.quests.get(i).getLimit()))).create();
                        player.spigot().sendMessage(component);
                    }
                    if (this.plugin.settings.quests.get(i).getCoolDown() > 0) {
                        component = new ComponentBuilder(this.plugin.misc.translateText("&fCoolDown: ")).append(this.plugin.misc.translateText(String.valueOf(this.plugin.settings.quests.get(i).getCoolDown())) + " seconds.").create();
                        player.spigot().sendMessage(component);
                    }
                    if (this.plugin.settings.quests.get(i).getRequirements().size() > 0) {
                        component = new ComponentBuilder("&6Item Requirements:").create();
                        player.spigot().sendMessage(component);
                        for (String q : this.plugin.settings.quests.get(i).getRequirements().keySet()) {
                            component = new ComponentBuilder(q + ": ").append(String.valueOf(this.plugin.settings.quests.get(i).getRequirements().get(q))).create();
                            player.spigot().sendMessage(component);
                        }
                    }
                    component = new ComponentBuilder(this.plugin.misc.translateText("&4Rewards: ")).create();
                    player.spigot().sendMessage(component);
                    if (this.plugin.settings.quests.get(i).getCurrency() > 0) {
                        component = new ComponentBuilder(this.plugin.misc.translateText(String.valueOf(this.plugin.settings.quests.get(i).getCurrency()))).append(" ").append(this.plugin.settings.customMoneyName).create();
                        player.spigot().sendMessage(component);
                    }
                    if (this.plugin.settings.dbType.equalsIgnoreCase("SQLite")) {
                        if (this.plugin.settings.economyVault) {
                            component = new ComponentBuilder(this.plugin.settings.economyVaultSymbol).append(String.valueOf(this.plugin.settings.quests.get(i).getVault())).create();
                            player.spigot().sendMessage(component);
                        }
                        component = new ComponentBuilder(this.plugin.misc.translateText("&fTotal ")).append(this.plugin.settings.quests.get(i).getTitle()).append(this.plugin.misc.translateText("&fCompletions: ")).append(this.plugin.settings.db.getQuestTally(player.getUniqueId().toString(), s)).create();
                        player.spigot().sendMessage(component);
                    } else {
                        if (this.plugin.settings.economyVault) {
                            component = new ComponentBuilder(this.plugin.settings.economyVaultSymbol).append(String.valueOf(this.plugin.settings.quests.get(i).getVault())).create();
                            player.spigot().sendMessage(component);
                        }
                        component = new ComponentBuilder(this.plugin.misc.translateText("&fTotal ")).append(this.plugin.settings.quests.get(i).getTitle()).append(" ").append(this.plugin.misc.translateText("&fCompletions: ")).append(this.plugin.settings.data.getQuestTally(player.getUniqueId().toString(), s)).create();
                        player.spigot().sendMessage(component);
                    }
                }
                ++i;
            }
        }
    }

    @Override
    public void perform(CommandSender sender, String[] args) {
        if (sender instanceof Player) {
            this.perform((Player)sender, args);
        } else {
            BaseComponent[] component = new ComponentBuilder("Only players can issue this command").create();
            sender.spigot().sendMessage(component);
        }
    }

    public boolean isInt(String s) {
        try {
            Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }
}

