/*
 * Decompiled with CFR 0.152.
 */
package com.itsrainingplex.Commands.RaindropQuests;

import com.itsrainingplex.Commands.SubCommand;
import com.itsrainingplex.RaindropQuests;
import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class MelonWand
extends SubCommand {
    private final ItemStack wand;
    private final RaindropQuests plugin;

    public MelonWand(@NotNull RaindropQuests plugin) {
        this.plugin = plugin;
        this.wand = new ItemStack(Objects.requireNonNullElse(Material.getMaterial((String)plugin.settings.autoMelonsConfig.wandMaterial().toUpperCase()), Material.STICK));
        this.updateWand(10);
    }

    @Override
    public String getName() {
        return "MelonWand";
    }

    @Override
    public String getDescription() {
        return "Gives the player a melon wand";
    }

    @Override
    public String getSyntax() {
        return "/" + this.plugin.settings.prefix + " MelonWand <Charges> <PlayerName>";
    }

    @Override
    public void perform(@NotNull Player player, String[] args) {
        if (player.hasPermission("RaindropQuests.command.MelonWand")) {
            if (args.length > 0) {
                if (args.length == 2) {
                    if (this.isInt(args[1])) {
                        this.updateWand(Integer.parseInt(args[1]));
                        player.getInventory().addItem(new ItemStack[]{this.wand});
                    } else {
                        Player target = Bukkit.getPlayer((String)args[1]);
                        this.updateWand(10);
                        assert (target != null);
                        target.getInventory().addItem(new ItemStack[]{this.wand});
                    }
                } else if (args.length == 3) {
                    if (this.isInt(args[1])) {
                        Player target = Bukkit.getPlayer((String)args[2]);
                        if (target != null) {
                            this.updateWand(Integer.parseInt(args[1]));
                            target.getInventory().addItem(new ItemStack[]{this.wand});
                        } else {
                            BaseComponent[] component = new ComponentBuilder("Incorrect parameters: ").append(this.getSyntax()).create();
                            player.spigot().sendMessage(component);
                        }
                    } else {
                        Player target = Bukkit.getPlayer((String)args[1]);
                        if (target != null) {
                            this.updateWand(Integer.parseInt(args[2]));
                            target.getInventory().addItem(new ItemStack[]{this.wand});
                        } else {
                            BaseComponent[] component = new ComponentBuilder("Incorrect parameters: ").append(this.getSyntax()).create();
                            player.spigot().sendMessage(component);
                        }
                    }
                } else {
                    BaseComponent[] component = new ComponentBuilder("Incorrect parameters: ").append(this.getSyntax()).create();
                    player.spigot().sendMessage(component);
                }
            } else {
                this.updateWand(10);
                player.getInventory().addItem(new ItemStack[]{this.wand});
            }
        }
    }

    @Override
    public void perform(CommandSender sender, String[] args) {
        if (sender instanceof Player) {
            this.perform((Player)sender, args);
        } else {
            BaseComponent[] component = new ComponentBuilder("Only players can issue this command").create();
            sender.spigot().sendMessage(component);
        }
    }

    public boolean isInt(String s) {
        try {
            Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public void updateWand(int charge) {
        ItemMeta meta = this.wand.getItemMeta();
        assert (meta != null);
        meta.setDisplayName("Melon Wand");
        ArrayList<Object> lore = new ArrayList<Object>();
        if (charge == -1) {
            lore.add("Charges: Unlimited");
        } else {
            lore.add("Charges: " + charge);
        }
        meta.setLore(lore);
        PersistentDataContainer data = meta.getPersistentDataContainer();
        data.set(new NamespacedKey((Plugin)this.plugin, "usage"), PersistentDataType.INTEGER, (Object)charge);
        String uuid = UUID.randomUUID().toString();
        data.set(new NamespacedKey((Plugin)this.plugin, "UUID"), PersistentDataType.STRING, (Object)uuid);
        this.wand.setItemMeta(meta);
    }
}

