/*
 * Decompiled with CFR 0.152.
 */
package com.itsrainingplex.Commands.Kills;

import com.itsrainingplex.Commands.SubCommand;
import com.itsrainingplex.RaindropQuests;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.bukkit.MythicBukkit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.TreeMap;
import java.util.UUID;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class KillTop
extends SubCommand {
    private final RaindropQuests plugin;

    public KillTop(RaindropQuests plugin) {
        this.plugin = plugin;
    }

    @Override
    public String getName() {
        return "KillTop";
    }

    @Override
    public String getDescription() {
        return "Get top stats for player or mob";
    }

    @Override
    public String getSyntax() {
        return "/" + this.plugin.settings.prefix + " KillTop {player_name | mob_name}";
    }

    @Override
    public void perform(@NotNull Player player, String[] args) {
        if (player.hasPermission("RaindropQuests.command.KillTop")) {
            this.runCommand((CommandSender)player, args);
        }
    }

    @Override
    public void perform(CommandSender sender, String[] args) {
        this.runCommand(sender, args);
    }

    public void runCommand(CommandSender sender, String @NotNull [] args) {
        if (args.length <= 1) {
            BaseComponent[] component = new ComponentBuilder("Invalid arguments: ").append(" | ").append(this.getSyntax()).create();
            sender.spigot().sendMessage(component);
        } else if (args.length == 2) {
            Player p = Bukkit.getPlayer((String)args[1]);
            if (p == null) {
                List<String> result = this.plugin.settings.vanillaMobsTypes.stream().map(String::toLowerCase).toList();
                if (result.contains(args[1].toLowerCase())) {
                    if (this.plugin.settings.dbType.equalsIgnoreCase("SQLite")) {
                        ArrayList<String> list = this.plugin.settings.db.getAllPlayers();
                        TreeMap<Integer, String> map = new TreeMap<Integer, String>(Collections.reverseOrder());
                        for (String s : list) {
                            map.put(this.plugin.settings.db.getKillCount(s, args[1].toLowerCase()), Objects.requireNonNull(Bukkit.getOfflinePlayer((UUID)UUID.fromString(s))).getName());
                        }
                        BaseComponent[] component = new ComponentBuilder("----------------------------------------").color(ChatColor.YELLOW).create();
                        sender.spigot().sendMessage(component);
                        String str = args[1].substring(0, 1).toUpperCase() + args[1].substring(1).toLowerCase().replace('_', ' ');
                        str = str.substring(0, str.indexOf(32) + 1) + str.substring(str.indexOf(32) + 1, str.indexOf(32) + 2).toUpperCase() + str.substring(str.indexOf(32) + 2);
                        component = new ComponentBuilder("TOP STATS - ").color(ChatColor.RED).append(str).color(ChatColor.BLUE).create();
                        KillTop.prepareHeader(sender, map, component);
                    } else {
                        ArrayList<String> list = this.plugin.settings.data.getAllPlayers();
                        TreeMap<Integer, String> map = new TreeMap<Integer, String>(Collections.reverseOrder());
                        for (String s : list) {
                            map.put(this.plugin.settings.data.getKillCount(s, args[1].toLowerCase()), Objects.requireNonNull(Bukkit.getOfflinePlayer((UUID)UUID.fromString(s))).getName());
                        }
                        BaseComponent[] component = new ComponentBuilder("----------------------------------------").color(ChatColor.YELLOW).create();
                        sender.spigot().sendMessage(component);
                        String str = args[1].substring(0, 1).toUpperCase() + args[1].substring(1).toLowerCase().replace('_', ' ');
                        str = str.substring(0, str.indexOf(32) + 1) + str.substring(str.indexOf(32) + 1, str.indexOf(32) + 2).toUpperCase() + str.substring(str.indexOf(32) + 2);
                        component = new ComponentBuilder("TOP STATS - ").color(ChatColor.RED).append(str).color(ChatColor.BLUE).create();
                        KillTop.prepareHeader(sender, map, component);
                    }
                } else {
                    BaseComponent[] component = new ComponentBuilder("Mob or player not found: ").append(args[1]).create();
                    sender.spigot().sendMessage(component);
                }
            } else {
                TreeMap<Integer, String> map = new TreeMap<Integer, String>(Collections.reverseOrder());
                if (this.plugin.settings.dbType.equalsIgnoreCase("SQLite")) {
                    for (String str : this.plugin.settings.vanillaMobsTypes) {
                        map.put(this.plugin.settings.db.getKillCount(p.getUniqueId().toString(), str), str);
                    }
                } else {
                    for (String str : this.plugin.settings.vanillaMobsTypes) {
                        map.put(this.plugin.settings.data.getKillCount(p.getUniqueId().toString(), str), str);
                    }
                }
                BaseComponent[] component = new ComponentBuilder("----------------------------------------").color(ChatColor.YELLOW).create();
                sender.spigot().sendMessage(component);
                component = new ComponentBuilder("TOP MOB STATS - ").color(ChatColor.RED).append(args[1]).color(ChatColor.BLUE).create();
                sender.spigot().sendMessage(component);
                KillTop.prepareListPlayer(sender, map);
            }
        }
    }

    public static void prepareListPlayer(@NotNull CommandSender sender, @NotNull TreeMap<Integer, String> map) {
        BaseComponent[] component = new ComponentBuilder("----------------------------------------").color(ChatColor.YELLOW).create();
        sender.spigot().sendMessage(component);
        KillTop.prepareList(sender, map);
    }

    public static void prepareHeader(@NotNull CommandSender sender, TreeMap<Integer, String> map, BaseComponent[] component) {
        sender.spigot().sendMessage(component);
        component = new ComponentBuilder("----------------------------------------").color(ChatColor.YELLOW).create();
        sender.spigot().sendMessage(component);
        KillTop.prepareList(sender, map);
    }

    private static void prepareList(CommandSender sender, @NotNull TreeMap<Integer, String> map) {
        BaseComponent[] component;
        int count = 0;
        for (int i : map.keySet()) {
            if (count == 10) break;
            if (i == 0) continue;
            String str = MythicBukkit.inst().getMobManager().getMythicMob(map.get(i)).isPresent() ? String.valueOf(((MythicMob)MythicBukkit.inst().getMobManager().getMythicMob(map.get(i)).get()).getDisplayName()) : Objects.requireNonNull(EntityType.valueOf((String)map.get(i).toUpperCase()).getEntityClass()).getSimpleName();
            component = new ComponentBuilder("| ").color(ChatColor.YELLOW).append(str).color(ChatColor.WHITE).append(": ").append(String.valueOf(i)).color(ChatColor.BLUE).create();
            sender.spigot().sendMessage(component);
            ++count;
        }
        component = new ComponentBuilder("----------------------------------------").color(ChatColor.YELLOW).create();
        sender.spigot().sendMessage(component);
    }
}

