/*
 * Decompiled with CFR 0.152.
 */
package com.itsrainingplex.Commands.Kills;

import com.itsrainingplex.Commands.SubCommand;
import com.itsrainingplex.RaindropQuests;
import java.util.Objects;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class KillCount
extends SubCommand {
    private final RaindropQuests plugin;

    public KillCount(RaindropQuests plugin) {
        this.plugin = plugin;
    }

    @Override
    public String getName() {
        return "KillCount";
    }

    @Override
    public String getDescription() {
        return "Get kill count of a vanilla mob";
    }

    @Override
    public String getSyntax() {
        return "/" + this.plugin.settings.prefix + " KillCount <PlayerName> <MobName>";
    }

    @Override
    public void perform(@NotNull Player player, String @NotNull [] args) {
        if (Objects.requireNonNull(Bukkit.getPlayer((String)args[1])).getUniqueId().equals(player.getUniqueId())) {
            if (player.hasPermission("RaindropQuests.command.KillCount")) {
                this.checkCommands((CommandSender)player, args);
            }
        } else if (player.hasPermission("RaindropQuests.command.KillCountOthers")) {
            this.checkCommands((CommandSender)player, args);
        }
    }

    @Override
    public void perform(CommandSender sender, String[] args) {
        this.checkCommands(sender, args);
    }

    private void checkCommands(CommandSender sender, String @NotNull [] args) {
        if (args.length != 3) {
            BaseComponent[] component = new ComponentBuilder("Invalid arguments: ").append(this.getSyntax()).create();
            sender.spigot().sendMessage(component);
            return;
        }
        if (Bukkit.getPlayer((String)args[1]) == null) {
            BaseComponent[] component = new ComponentBuilder("Player not found").create();
            sender.spigot().sendMessage(component);
            return;
        }
        boolean found = false;
        for (String s : this.plugin.settings.vanillaMobsTypes) {
            if (!args[2].equalsIgnoreCase(s)) continue;
            found = true;
            break;
        }
        if (!found) {
            BaseComponent[] component = new ComponentBuilder("Type not found").create();
            sender.spigot().sendMessage(component);
            return;
        }
        int count = this.plugin.settings.dbType.equalsIgnoreCase("SQLite") ? this.plugin.settings.db.getKillCount(Objects.requireNonNull(Bukkit.getPlayer((String)args[1])).getUniqueId().toString(), args[2]) : this.plugin.settings.data.getKillCount(Objects.requireNonNull(Bukkit.getPlayer((String)args[1])).getUniqueId().toString(), args[2]);
        BaseComponent[] component = args[2].equalsIgnoreCase("player") ? new ComponentBuilder("[").append(args[1]).append("] ").append(" PVP Count: ").append(String.valueOf(count)).append(" ").append(args[2]).create() : new ComponentBuilder("[").append(args[1]).append("] ").append(" Mob Count: ").append(String.valueOf(count)).append(" ").append(args[2]).create();
        sender.spigot().sendMessage(component);
    }
}

