/*
 * Decompiled with CFR 0.152.
 */
package com.itsrainingplex.Commands;

import com.itsrainingplex.Commands.EliteModSummons.CallMod;
import com.itsrainingplex.Commands.EliteModSummons.EMS;
import com.itsrainingplex.Commands.Kills.KillCount;
import com.itsrainingplex.Commands.Kills.KillTop;
import com.itsrainingplex.Commands.Kills.MythicCount;
import com.itsrainingplex.Commands.Kills.MythicTop;
import com.itsrainingplex.Commands.Main.Main;
import com.itsrainingplex.Commands.RaindropQuests.AutoCondense;
import com.itsrainingplex.Commands.RaindropQuests.Give;
import com.itsrainingplex.Commands.RaindropQuests.Info;
import com.itsrainingplex.Commands.RaindropQuests.LoadBlocks;
import com.itsrainingplex.Commands.RaindropQuests.MelonWand;
import com.itsrainingplex.Commands.RaindropQuests.Passive;
import com.itsrainingplex.Commands.RaindropQuests.PassivesGUI;
import com.itsrainingplex.Commands.RaindropQuests.PassivesNPC;
import com.itsrainingplex.Commands.RaindropQuests.Quest;
import com.itsrainingplex.Commands.RaindropQuests.QuestGUI;
import com.itsrainingplex.Commands.RaindropQuests.QuestNPC;
import com.itsrainingplex.Commands.RaindropQuests.RanksNPC;
import com.itsrainingplex.Commands.RaindropQuests.Reload;
import com.itsrainingplex.Commands.RaindropQuests.SaveBlocks;
import com.itsrainingplex.Commands.Ranks.CreateGroups;
import com.itsrainingplex.Commands.Ranks.PrefixGUI;
import com.itsrainingplex.Commands.Ranks.PrefixNPC;
import com.itsrainingplex.Commands.Ranks.RankTree;
import com.itsrainingplex.Commands.Ranks.RankUp;
import com.itsrainingplex.Commands.Ranks.SuffixGUI;
import com.itsrainingplex.Commands.Ranks.SuffixNPC;
import com.itsrainingplex.Commands.SubCommand;
import com.itsrainingplex.RaindropQuests;
import java.util.ArrayList;
import java.util.List;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class CommandManager
implements CommandExecutor,
TabCompleter {
    private final RaindropQuests plugin;
    private final ArrayList<SubCommand> subcommands = new ArrayList();

    public CommandManager(RaindropQuests plugin) {
        this.plugin = plugin;
        this.subcommands.add(new Info(plugin));
        this.subcommands.add(new QuestGUI(plugin));
        this.subcommands.add(new PassivesGUI(plugin));
        if (plugin.settings.citizens) {
            this.subcommands.add(new QuestNPC(plugin));
            this.subcommands.add(new PassivesNPC(plugin));
            this.subcommands.add(new RanksNPC(plugin));
            this.subcommands.add(new PrefixNPC(plugin));
            this.subcommands.add(new SuffixNPC(plugin));
        }
        this.subcommands.add(new AutoCondense(plugin));
        this.subcommands.add(new MelonWand(plugin));
        this.subcommands.add(new SaveBlocks(plugin));
        this.subcommands.add(new Give(plugin));
        this.subcommands.add(new Passive(plugin));
        this.subcommands.add(new Quest(plugin));
        this.subcommands.add(new LoadBlocks(plugin));
        if (plugin.settings.ranksEnabled) {
            this.subcommands.add(new RankUp(plugin));
            this.subcommands.add(new RankTree(plugin));
            this.subcommands.add(new Reload(plugin));
            this.subcommands.add(new CreateGroups(plugin));
            this.subcommands.add(new PrefixGUI(plugin));
            this.subcommands.add(new SuffixGUI(plugin));
        }
        if (plugin.settings.ems.enabled) {
            this.subcommands.add(new CallMod(plugin.settings.ems.mods, plugin.settings.ems.support, plugin.settings.ems.messages, plugin));
            this.subcommands.add(new EMS(plugin.settings.ems.mods, plugin.settings.ems.support, plugin.settings.ems.messages, plugin));
        }
        this.subcommands.add(new Main(plugin));
        this.subcommands.add(new KillCount(plugin));
        this.subcommands.add(new KillTop(plugin));
        if (plugin.settings.mythicMobs) {
            this.subcommands.add(new MythicCount(plugin));
            this.subcommands.add(new MythicTop(plugin));
        }
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (sender instanceof Player) {
            Player p = (Player)sender;
            if (args.length == 0) {
                BaseComponent[] component = new ComponentBuilder("--------------------------------").create();
                p.spigot().sendMessage(component);
                for (int i = 0; i < this.getSubcommands().size(); ++i) {
                    component = new ComponentBuilder(this.getSubcommands().get(i).getSyntax()).append(" - ").append(this.getSubcommands().get(i).getDescription()).create();
                    p.spigot().sendMessage(component);
                }
                component = new ComponentBuilder("--------------------------------").create();
                p.spigot().sendMessage(component);
            } else {
                for (int i = 0; i < this.getSubcommands().size(); ++i) {
                    if (!args[0].equalsIgnoreCase(this.getSubcommands().get(i).getName())) continue;
                    this.getSubcommands().get(i).perform(p, args);
                    return true;
                }
            }
        } else if (args.length == 0) {
            this.plugin.getLogger().info("--------------------------------");
            for (int i = 0; i < this.getSubcommands().size(); ++i) {
                this.plugin.getLogger().info(this.getSubcommands().get(i).getSyntax() + " - " + this.getSubcommands().get(i).getDescription());
            }
            this.plugin.getLogger().info("--------------------------------");
        } else {
            for (int i = 0; i < this.getSubcommands().size(); ++i) {
                if (!args[0].equalsIgnoreCase(this.getSubcommands().get(i).getName())) continue;
                this.getSubcommands().get(i).perform(sender, args);
                return true;
            }
        }
        return true;
    }

    public ArrayList<SubCommand> getSubcommands() {
        return this.subcommands;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String @NotNull [] args) {
        ArrayList<String> subs = new ArrayList<String>();
        if (args.length == 0) {
            subs.add("rq");
        } else if (args.length == 1) {
            if (sender.hasPermission("RaindropQuests.command.info")) {
                subs.add("info");
            }
            if (sender.hasPermission("RaindropQuests.command.MainGUI")) {
                subs.add("MainGUI");
            }
            if (sender.hasPermission("RaindropQuests.command.QuestGUI")) {
                subs.add("QuestGUI");
            }
            if (sender.hasPermission("RaindropQuests.command.PassiveGUI")) {
                subs.add("PassivesGUI");
            }
            if (this.plugin.settings.citizens) {
                if (sender.hasPermission("RaindropQuests.command.QuestNPC")) {
                    subs.add("QuestNPC");
                }
                if (sender.hasPermission("RaindropQuests.command.PassiveNPC")) {
                    subs.add("PassivesNPC");
                }
                if (sender.hasPermission("RaindropQuests.command.RanksNPC")) {
                    subs.add("RanksNPC");
                }
                if (sender.hasPermission("RaindropQuests.command.PrefixNPC")) {
                    subs.add("PrefixNPC");
                }
                if (sender.hasPermission("RaindropQuests.command.SuffixNPC")) {
                    subs.add("SuffixNPC");
                }
            }
            if (sender.hasPermission("RaindropQuests.command.MelCon")) {
                subs.add("MelCon");
            }
            if (sender.hasPermission("RaindropQuests.command.MelonWand")) {
                subs.add("MelonWand");
            }
            if (sender.hasPermission("RaindropQuests.command.SaveBlocks")) {
                subs.add("SaveBlocks");
            }
            if (sender.hasPermission("RaindropQuests.command.LoadBlocks")) {
                subs.add("LoadBlocks");
            }
            if (sender.hasPermission("RaindropQuests.command.give")) {
                subs.add("Give");
            }
            if (sender.hasPermission("RaindropQuests.command.passive")) {
                subs.add("Passive");
            }
            if (sender.hasPermission("RaindropQuests.command.quest")) {
                subs.add("Quest");
            }
            if (sender.hasPermission("RaindropQuests.command.CreateGroups")) {
                subs.add("CreateGroups");
            }
            if (sender.hasPermission("RaindropQuests.command.PrefixGUI")) {
                subs.add("PrefixGUI");
            }
            if (sender.hasPermission("RaindropQuests.command.tree")) {
                subs.add("RankTree");
            }
            if (sender.hasPermission("RaindropQuests.command.RankUp")) {
                subs.add("RankUp");
            }
            if (sender.hasPermission("RaindropQuests.command.reload")) {
                subs.add("Reload");
            }
            if (sender.hasPermission("RaindropQuests.command.SuffixGUI")) {
                subs.add("SuffixGUI");
            }
            if (sender.hasPermission("RaindropQuests.command.KillCount")) {
                subs.add("KillCount");
            }
            if (sender.hasPermission("RaindropQuests.command.KillTop")) {
                subs.add("KillTop");
            }
            if (sender.hasPermission("RaindropQuests.command.MythicCount")) {
                subs.add("MythicCount");
            }
            if (sender.hasPermission("RaindropQuests.command.MythicTop")) {
                subs.add("MythicTop");
            }
        }
        if (sender.hasPermission("RaindropQuests.command.KillTop") && args.length == 2 && args[0].equalsIgnoreCase("KillTop")) {
            for (Player p : Bukkit.getOnlinePlayers()) {
                subs.add(p.getName());
            }
        }
        if (sender.hasPermission("RaindropQuests.command.MythicTop") && args.length == 2 && args[0].equalsIgnoreCase("MythicTop")) {
            for (Player p : Bukkit.getOnlinePlayers()) {
                subs.add(p.getName());
            }
        }
        if (sender.hasPermission("RaindropQuests.command.KillCount")) {
            if (args.length == 2 && args[0].equalsIgnoreCase("KillCount")) {
                for (Player p : Bukkit.getOnlinePlayers()) {
                    subs.add(p.getName());
                }
            }
            if (args.length == 3 && args[0].equalsIgnoreCase("KillCount")) {
                subs.addAll(this.plugin.settings.vanillaMobsTypes);
            }
        }
        if (sender.hasPermission("RaindropQuests.command.MythicCount")) {
            if (args.length == 2 && args[0].equalsIgnoreCase("MythicCount")) {
                for (Player p : Bukkit.getOnlinePlayers()) {
                    subs.add(p.getName());
                }
            }
            if (args.length == 3 && args[0].equalsIgnoreCase("MythicCount")) {
                subs.addAll(this.plugin.settings.mythicMobTypes);
            }
        }
        if (sender.hasPermission("RaindropQuests.command.MelonWand")) {
            if (args.length == 2 && args[0].equalsIgnoreCase("MelonWand")) {
                for (Player p : Bukkit.getOnlinePlayers()) {
                    subs.add(p.getName());
                }
                subs.add("<Charges>");
            }
            if (args.length == 3 && args[0].equalsIgnoreCase("MelonWand")) {
                subs.add("<Charges>");
                for (Player p : Bukkit.getOnlinePlayers()) {
                    subs.add(p.getName());
                }
            }
        }
        if (args.length == 2 && (args[0].equalsIgnoreCase("Give") || args[0].equalsIgnoreCase("Passive"))) {
            for (Player p : Bukkit.getOnlinePlayers()) {
                subs.add(p.getName());
            }
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("Give")) {
            for (String s : this.plugin.settings.customItemMap.keySet()) {
                if (!sender.hasPermission("RaindropQuests.command." + s)) continue;
                subs.add(s);
            }
        }
        if (args.length == 4 && args[0].equalsIgnoreCase("Give")) {
            subs.add("<Amount>");
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("Passive")) {
            for (String s : this.plugin.settings.passiveNames) {
                if (!sender.hasPermission("RaindropQuests.command." + s)) continue;
                subs.add(s);
            }
        }
        if (args.length == 4 && args[0].equalsIgnoreCase("Passive")) {
            subs.add("true");
            subs.add("false");
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("Quest")) {
            subs.addAll(this.plugin.settings.questNames);
        }
        return subs;
    }
}

