/*
 * Decompiled with CFR 0.152.
 */
package com.itsrainingplex.AutoMelons;

import com.itsrainingplex.RaindropQuests;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ManageInventory {
    private final RaindropQuests plugin;

    public ManageInventory(RaindropQuests plugin) {
        this.plugin = plugin;
    }

    public int getTotalSlices(@NotNull Player player) {
        int amount = 0;
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null || item.getType() != Material.MELON_SLICE) continue;
            amount += item.getAmount();
        }
        return amount;
    }

    public int getRemainderSlices(int amount) {
        return amount % 9;
    }

    public int getRemainderMelons(int amount) {
        return amount % 64;
    }

    public int getTotalMelons(int amount) {
        return amount / 9;
    }

    public int getMelonStacks(int amount) {
        return amount / 64;
    }

    public boolean condense(@NotNull Player player) {
        if (player.getInventory().firstEmpty() != -1) {
            return this.runCondense(player);
        }
        if (player.getInventory().firstEmpty() == -1 && this.plugin.settings.autoMelonsConfig.allowFullInventory()) {
            return this.runCondense(player);
        }
        return false;
    }

    private boolean runCondense(Player player) {
        int total = this.getTotalSlices(player);
        if (total > 9 || this.plugin.settings.autoMelonsConfig.useEmpty()) {
            int totalMelons = this.getTotalMelons(total);
            int remainingSlices = this.getRemainderSlices(total);
            int totalMelonStacks = this.getMelonStacks(totalMelons);
            int remainingMelons = this.getRemainderMelons(totalMelons);
            player.getInventory().remove(Material.MELON_SLICE);
            ItemStack melonStacks = new ItemStack(Material.MELON, 64);
            ItemStack melons = new ItemStack(Material.MELON, remainingMelons);
            ItemStack slices = new ItemStack(Material.MELON_SLICE, remainingSlices);
            for (int i = 0; i < totalMelonStacks; ++i) {
                player.getInventory().addItem(new ItemStack[]{melonStacks});
            }
            player.getInventory().addItem(new ItemStack[]{melons});
            player.getInventory().addItem(new ItemStack[]{slices});
            String m = player.getName() + " converted " + total + " melon slices to " + totalMelons + " melons. With " + remainingSlices + " melon slices left.";
            this.plugin.settings.send.sendMessage(player, m, this.plugin.settings.autoMelonsConfig.discord(), this.plugin.settings.autoMelonsConfig.logger(), this.plugin.settings.autoMelonsConfig.broadcast(), this.plugin.settings.autoMelonsConfig.player(), this.plugin.settings.discords.get("Passives"));
            return true;
        }
        BaseComponent[] component = new ComponentBuilder("Not enough melons to condense!").create();
        player.spigot().sendMessage(component);
        return false;
    }
}

