/*
 * Decompiled with CFR 0.152.
 */
package io.signality.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.TextComponent;

public class Util {
    public static String color(String msg) {
        Pattern HEX_PATTERN = Pattern.compile("&#(\\w{5}[0-9a-f])");
        Matcher matcher = HEX_PATTERN.matcher(msg);
        StringBuilder builder = new StringBuilder();
        while (matcher.find()) {
            matcher.appendReplacement(builder, ChatColor.of((String)("#" + matcher.group(1))).toString());
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)matcher.appendTail(builder).toString());
    }

    public static List<String> colorLore(List<String> lore) {
        for (int i = 0; i < lore.size(); ++i) {
            String s = lore.get(i);
            lore.set(i, Util.color(s));
        }
        return lore;
    }

    public static String capitalize(String str) {
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    public static String removeColor(String str) {
        str = Util.color(str);
        str = ChatColor.stripColor((String)str);
        str = str.replaceAll("\u27a4 ", "");
        return str;
    }

    public static List<String> uncolorLore(List<String> lore) {
        ArrayList<String> newLore = new ArrayList<String>();
        for (String loreLine : lore) {
            loreLine = Util.color(loreLine);
            loreLine = ChatColor.stripColor((String)loreLine);
            loreLine = loreLine.replaceAll("\u27a4 ", "");
            newLore.add(loreLine);
        }
        return newLore;
    }

    public static TextComponent[] toTextComponents(String input) {
        ArrayList<TextComponent> itemComponent = new ArrayList<TextComponent>();
        if (!input.contains("\u00a7x")) {
            TextComponent wordComponent = new TextComponent(Util.color(input));
            itemComponent.add(wordComponent);
            return itemComponent.toArray(new TextComponent[0]);
        }
        for (String textSplit : input.split("\u00a7x")) {
            if (textSplit.isEmpty()) continue;
            if (textSplit.length() - textSplit.replaceAll("\u00a7", "").length() == 1) {
                TextComponent wordComponent = new TextComponent(Util.color(textSplit));
                itemComponent.add(wordComponent);
                continue;
            }
            String color = textSplit.substring(0, 12).replace("\u00a7x", "").replaceAll("\u00a7", "");
            String text = textSplit.substring(12);
            TextComponent wordComponent = new TextComponent(text);
            wordComponent.setColor(ChatColor.of((String)("#" + color)));
            itemComponent.add(wordComponent);
        }
        return itemComponent.toArray(new TextComponent[0]);
    }
}

