/*
 * Decompiled with CFR 0.152.
 */
package io.signality.util;

import io.signality.VoteSleep;
import io.signality.util.ConfigUpdater;
import io.signality.util.Util;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class ConfigFile {
    private static final HashMap<Files, File> files = new HashMap();
    private static final HashMap<Files, FileConfiguration> configurations = new HashMap();

    public void setup(Plugin plugin) {
        if (!plugin.getDataFolder().exists()) {
            ConfigFile.IGNORE_RESULT(plugin.getDataFolder().mkdirs());
        }
        files.clear();
        for (Files file : Files.values()) {
            File newFile;
            block14: {
                newFile = new File(plugin.getDataFolder(), file.getFileLocation());
                if (!newFile.exists()) {
                    try {
                        String resourcePath = file.fileLocation;
                        if (resourcePath != null && !resourcePath.equals("")) {
                            InputStream in = plugin.getResource(resourcePath = resourcePath.replace('\\', '/'));
                            if (in == null) {
                                throw new IllegalArgumentException("The embedded resource '" + resourcePath + "' cannot be found");
                            }
                            File outFile = new File(plugin.getDataFolder(), resourcePath);
                            int lastIndex = resourcePath.lastIndexOf(47);
                            File outDir = new File(plugin.getDataFolder(), resourcePath.substring(0, Math.max(lastIndex, 0)));
                            if (!outDir.exists()) {
                                ConfigFile.IGNORE_RESULT(outDir.mkdirs());
                            }
                            try {
                                int len;
                                if (outFile.exists()) {
                                    plugin.getLogger().warning(Util.color("&cCould not save &f" + outFile.getName() + " to " + outFile + " because " + outFile.getName() + " already exists."));
                                    break block14;
                                }
                                FileOutputStream ex = new FileOutputStream(outFile);
                                byte[] buf = new byte[1024];
                                while ((len = in.read(buf)) > 0) {
                                    ex.write(buf, 0, len);
                                }
                                ex.close();
                                in.close();
                            }
                            catch (IOException var10) {
                                plugin.getLogger().warning(Util.color("&cCould not save &f" + outFile.getName() + " to " + outFile));
                                var10.printStackTrace();
                            }
                            break block14;
                        }
                        throw new IllegalArgumentException("ResourcePath cannot be null or empty");
                    }
                    catch (Exception e) {
                        plugin.getLogger().severe(Util.color("&8[VoteSleep] &cFailed to load &7" + file.getFileName()));
                        e.printStackTrace();
                        continue;
                    }
                }
            }
            files.put(file, newFile);
            configurations.put(file, (FileConfiguration)YamlConfiguration.loadConfiguration((File)newFile));
            plugin.getLogger().info(Util.color("&8[VoteSleep] &9Loaded &7" + file.getFileName()));
            try {
                ConfigUpdater.update(plugin, file.getFileName(), newFile, new String[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void IGNORE_RESULT(boolean b) {
    }

    public static FileConfiguration get(Files file) {
        return configurations.get((Object)file);
    }

    public static void reload(Files file) {
        configurations.put(file, (FileConfiguration)YamlConfiguration.loadConfiguration((File)files.get((Object)file)));
    }

    public static void reloadAll() {
        Arrays.stream(Files.values()).forEach(files1 -> {
            VoteSleep.getInstance().getLogger().info(Util.color("&8[VoteSleep] &9Loaded &7" + files1));
            ConfigFile.reload(files1);
        });
    }

    public static enum Files {
        VOTESLEEP("sleep.yml", "sleep.yml");

        private final String fileName;
        private final String fileLocation;

        private Files(String fileName, String fileLocation) {
            this.fileName = fileName;
            this.fileLocation = fileLocation;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getFileLocation() {
            return this.fileLocation;
        }
    }
}

