/*
 * Decompiled with CFR 0.152.
 */
package io.signality.commands;

import io.signality.Sleep.SleepManager;
import io.signality.Sleep.SleepScheduler;
import io.signality.VoteSleep;
import io.signality.util.ConfigFile;
import io.signality.util.Methods;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Statistic;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

public class SleepCommand
implements CommandExecutor {
    static final FileConfiguration sleepConfig = ConfigFile.get(ConfigFile.Files.VOTESLEEP);
    private final VoteSleep instance = VoteSleep.getInstance();
    final Permission perms = VoteSleep.getPermissions();
    private final SleepManager sleepManager = SleepScheduler.getSleepManager();

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!command.getName().equals("sleep")) {
            return true;
        }
        CommandSender commandSender = sender;
        if (!(commandSender instanceof Player)) {
            return true;
        }
        final Player player = (Player)commandSender;
        if (args.length > 0) {
            String prefix = sleepConfig.getString("messages.prefix");
            switch (args[0].toLowerCase()) {
                case "protection": {
                    if (this.perms.has(player, "sleep.protection")) {
                        boolean isDisabled = this.sleepManager.arePhantomsDisabled(player);
                        if (isDisabled) {
                            Methods.playerMessage(player, prefix + sleepConfig.getString("messages.phantomsDisabled"));
                            this.sleepManager.enablePhantoms(player);
                            break;
                        }
                        new BukkitRunnable(){

                            public void run() {
                                player.setStatistic(Statistic.TIME_SINCE_REST, 0);
                            }
                        }.runTask((Plugin)this.instance);
                        this.sleepManager.disablePhantoms(player);
                        Methods.playerMessage(player, prefix + sleepConfig.getString("messages.phantomsEnabled"));
                        break;
                    }
                    Methods.playerMessage(player, prefix + sleepConfig.getString("messages.noperms"));
                }
            }
            return true;
        }
        this.sleepManager.doVote(player.getWorld(), player);
        return true;
    }
}

