/*
 * Decompiled with CFR 0.152.
 */
package io.signality;

import io.signality.Sleep.SleepScheduler;
import io.signality.commands.SleepCommand;
import io.signality.commands.VoteSleepCommand;
import io.signality.events.CreatureSpawn;
import io.signality.events.JointEvent;
import io.signality.events.TabComplete;
import io.signality.util.ConfigFile;
import io.signality.util.Metrics;
import io.signality.util.UpdateChecker;
import io.signality.util.Util;
import java.util.Objects;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public final class VoteSleep
extends JavaPlugin {
    private static VoteSleep instance;
    private static final ConfigFile configFiles;
    private static Permission perms;
    private boolean hasUpdate = false;

    public void onEnable() {
        instance = this;
        int bStatsID = 16792;
        Metrics metrics = new Metrics(this, bStatsID);
        int spigotID = 106021;
        new UpdateChecker(this, spigotID).getVersion(version -> {
            if (this.getDescription().getVersion().equals(version)) {
                this.getLogger().info("&8[VoteSleep] &aPlugin is up to date");
            } else {
                this.getLogger().info("&8[VoteSleep] &7Version " + version + " is now available");
                this.hasUpdate = true;
            }
        });
        configFiles.setup((Plugin)instance);
        RegisteredServiceProvider rspPerms = this.getServer().getServicesManager().getRegistration(Permission.class);
        if (rspPerms == null) {
            throw new RuntimeException("Disabled because a Permission plugin wasn't found");
        }
        perms = (Permission)rspPerms.getProvider();
        this.registerCommand(new VoteSleepCommand(), "votesleep");
        this.registerTabComplete("votesleep");
        this.registerCommand(new SleepCommand(), "sleep");
        this.registerTabComplete("sleep");
        this.registerScheduler(new SleepScheduler(), 1L);
        this.registerEvent(new CreatureSpawn());
        this.registerEvent(new JointEvent());
        this.getLogger().info(Util.color("&8[VoteSleep] &aPlugin Enabled"));
    }

    private void createDepend(String plugin) {
        if (Bukkit.getPluginManager().getPlugin(plugin) == null) {
            throw new RuntimeException("Disabled because " + plugin + " wasn't found");
        }
    }

    private void registerCommand(CommandExecutor executor, String ... command) {
        if (command.length == 1) {
            Objects.requireNonNull(this.getCommand(command[0])).setExecutor(executor);
            return;
        }
        for (String cmd : command) {
            Objects.requireNonNull(this.getCommand(cmd)).setExecutor(executor);
        }
    }

    private void registerEvent(Listener event) {
        Bukkit.getPluginManager().registerEvents(event, (Plugin)this);
    }

    private void registerTabComplete(String command) {
        Objects.requireNonNull(this.getCommand(command)).setTabCompleter((TabCompleter)new TabComplete());
    }

    private void registerScheduler(Runnable task, long ticks) {
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, task, 0L, ticks);
    }

    public static VoteSleep getInstance() {
        return instance;
    }

    public static Permission getPermissions() {
        return perms;
    }

    public void onDisable() {
        this.getLogger().info(Util.color("&aPlugin Disabled"));
    }

    public boolean hasUpdate() {
        return this.hasUpdate;
    }

    static {
        configFiles = new ConfigFile();
        perms = null;
    }
}

