/*
 * Decompiled with CFR 0.152.
 */
package io.signality.Sleep;

import io.signality.Sleep.SleepManager;
import io.signality.util.ConfigFile;
import io.signality.util.Methods;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class SleepScheduler
implements Runnable {
    private static final SleepManager sleepManager = new SleepManager();
    public static boolean night = false;
    private static boolean active = false;

    @Override
    public void run() {
        FileConfiguration sleepConfig = ConfigFile.get(ConfigFile.Files.VOTESLEEP);
        int morningTime = sleepConfig.getInt("morningTime");
        int nightTime = sleepConfig.getInt("nightTime");
        String prefix = sleepConfig.getString("messages.prefix");
        for (String worldName : sleepConfig.getStringList("allowedWorlds")) {
            World world = Bukkit.getWorld((String)worldName);
            boolean night = sleepManager.isNight(world);
            if (world == null) {
                return;
            }
            long currentTime = world.getTime();
            if (currentTime >= (long)morningTime && currentTime < (long)nightTime && night) {
                for (Player onlinePlayer : world.getPlayers()) {
                    Methods.playerMessage(onlinePlayer, prefix + sleepConfig.getString("messages.morningGreeting"));
                }
                SleepManager.resetVotes(world);
                sleepManager.setNight(world, false);
                SleepManager.skipping = false;
            }
            if (currentTime >= (long)nightTime && !night && active) {
                int votesNeeded = SleepManager.getVotesNeeded(world);
                for (Player onlinePlayer : world.getPlayers()) {
                    Methods.playerMessage(onlinePlayer, prefix + sleepConfig.getString("messages.nightBegins").replace("%votes%", "" + votesNeeded));
                }
                sleepManager.setNight(world, true);
                active = true;
                SleepManager.skipping = false;
            }
            if (active) continue;
            active = true;
        }
    }

    public static SleepManager getSleepManager() {
        return sleepManager;
    }
}

