/*
 * Decompiled with CFR 0.152.
 */
package io.signality.Sleep;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import io.signality.VoteSleep;
import io.signality.util.ConfigFile;
import io.signality.util.Methods;
import io.signality.util.TimeHandler;
import io.signality.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class SleepManager {
    public static boolean skipping = false;
    public static int votesNeeded = 1;
    public static HashMap<World, Boolean> nightStatus = new HashMap();
    public static Multimap<World, Player> sleepVote = ArrayListMultimap.create();
    public static List<Player> phantomsDisabled = new ArrayList<Player>();
    static final FileConfiguration sleepConfig = ConfigFile.get(ConfigFile.Files.VOTESLEEP);

    public void doVote(World world, Player player) {
        VoteSleep instance = VoteSleep.getInstance();
        Permission perms = VoteSleep.getPermissions();
        String prefix = sleepConfig.getString("messages.prefix");
        boolean foundWorld = false;
        for (String worldName : sleepConfig.getStringList("allowedWorlds")) {
            if (!player.getWorld().getName().equals(worldName)) continue;
            foundWorld = true;
        }
        if (!foundWorld) {
            Methods.playerMessage(player, prefix + sleepConfig.getString("messages.notallowed"));
            return;
        }
        if (!this.isNight(world)) {
            Methods.playerMessage(player, prefix + sleepConfig.getString("messages.nightOnly"));
            return;
        }
        if (skipping) {
            Methods.playerMessage(player, prefix + sleepConfig.getString("messages.morningSkipStill"));
            return;
        }
        if (SleepManager.hasVoted(world, player)) {
            Methods.playerMessage(player, Util.color(prefix + sleepConfig.getString("messages.voteOnce")));
            return;
        }
        if (sleepConfig.getBoolean("itemRequired") && !perms.has(player, "sleep.immunity")) {
            String categoryItem = sleepConfig.getString("itemNeeded");
            if (categoryItem == null) {
                categoryItem = "WHITE_BED";
            }
            ItemStack itemAdding = new ItemStack(Objects.requireNonNull(Material.matchMaterial((String)categoryItem)), 1);
            if (!player.getInventory().contains(itemAdding)) {
                Methods.playerMessage(player, prefix + sleepConfig.getString("messages.itemMissing"));
                return;
            }
        }
        votesNeeded = SleepManager.getVotesNeeded(world);
        SleepManager.addVote(world, player);
        boolean godVote = perms.has(player, "sleep.god");
        if (votesNeeded <= SleepManager.getVoteCount(world) || godVote) {
            skipping = true;
            if (sleepConfig.getBoolean("smoothSleep.enabled")) {
                new TimeHandler(instance, world);
            } else {
                world.setTime((long)sleepConfig.getInt("morningTime"));
            }
            SleepManager.resetVotes(world);
            for (Player onlinePlayer : player.getWorld().getPlayers()) {
                if (godVote) {
                    Methods.playerMessage(onlinePlayer, prefix + sleepConfig.getString("messages.voteGod"));
                    continue;
                }
                Methods.playerMessage(onlinePlayer, prefix + sleepConfig.getString("messages.morningSkip"));
            }
            return;
        }
        int votesNeeded = SleepManager.getVotesNeeded(world) - SleepManager.getVoteCount(world);
        String voteMessage = sleepConfig.getString("messages.votesNeeded").replace("%votes%", "" + votesNeeded);
        for (Player onlinePlayer : player.getWorld().getPlayers()) {
            Methods.playerMessage(onlinePlayer, prefix + voteMessage);
        }
    }

    public boolean arePhantomsDisabled(Player player) {
        return phantomsDisabled.contains(player);
    }

    public void disablePhantoms(Player player) {
        phantomsDisabled.add(player);
    }

    public void enablePhantoms(Player player) {
        phantomsDisabled.remove(player);
    }

    public boolean isNight(World world) {
        try {
            if (nightStatus.get(world).booleanValue()) {
                boolean status = nightStatus.get(world);
                return status;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public void setNight(World world, Boolean status) {
        nightStatus.put(world, status);
    }

    public static int getVotesNeeded(World world) {
        int totalPlayers = 0;
        for (Player player : world.getPlayers()) {
            ++totalPlayers;
        }
        double votePercentage = (double)sleepConfig.getInt("votePercentage") * 0.01;
        return (int)Math.round((double)totalPlayers * votePercentage);
    }

    public static int getVoteCount(World world) {
        if (sleepVote.keySet().contains(world)) {
            return sleepVote.get((Object)world).size();
        }
        return 0;
    }

    public static boolean hasVoted(World world, Player player) {
        if (sleepVote.keySet().contains(world)) {
            for (Player onlinePlayer : sleepVote.get((Object)world)) {
                if (onlinePlayer != player) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static void addVote(World world, Player player) {
        if (!SleepManager.hasVoted(world, player)) {
            sleepVote.put((Object)world, (Object)player);
        }
    }

    public static void resetVotes(World world) {
        sleepVote.get((Object)world).clear();
    }
}

