/*
 * Decompiled with CFR 0.152.
 */
package ga.juriantech.tnttag.utils;

import ga.juriantech.tnttag.utils.ChatUtils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemBuilder {
    private ItemStack item;
    private String name;
    private boolean hideAttributes;
    private List<String> lore = new ArrayList<String>();

    public ItemBuilder(Material material) {
        this.item = new ItemStack(material);
    }

    public ItemBuilder(Material material, short data) {
        this.item = new ItemStack(material, 1, data);
    }

    public ItemBuilder setAmount(int amount) {
        this.item.setAmount(amount);
        return this;
    }

    public ItemBuilder displayName(String name) {
        this.name = name;
        return this;
    }

    public ItemBuilder addLoreSpacer() {
        this.lore.add("");
        return this;
    }

    public ItemBuilder lore(String lore) {
        String[] lores;
        for (String splitLore : lores = lore.split("\n")) {
            this.lore.add(ChatUtils.colorize(splitLore));
        }
        return this;
    }

    public ItemBuilder hideAttributes() {
        this.hideAttributes = true;
        return this;
    }

    public ItemStack build() {
        ItemMeta meta = this.item.getItemMeta();
        meta.setDisplayName(this.name);
        meta.setLore(this.lore);
        if (this.hideAttributes) {
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        }
        this.item.setItemMeta(meta);
        return this.item.clone();
    }
}

