/*
 * Decompiled with CFR 0.152.
 */
package ga.juriantech.tnttag.utils;

import ga.juriantech.tnttag.Arena;
import ga.juriantech.tnttag.Tnttag;
import ga.juriantech.tnttag.objects.PlayerData;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class ChatUtils {
    public static String colorize(String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public static void sendMessage(Player player, String path) {
        if (ChatUtils.isEmptyMessage(Tnttag.customizationfile.getString(path))) {
            return;
        }
        PlayerData playerData = new PlayerData(player);
        player.sendMessage(ChatUtils.colorize(Tnttag.customizationfile.getString(path)).replace("{player}", player.getName()).replace("{wins}", String.valueOf(playerData.getWins())).replace("{timestagged}", String.valueOf(playerData.getTimesTagged())).replace("{tags}", String.valueOf(playerData.getTags())));
    }

    public static void sendMessage(Arena arena, Player player, String path) {
        if (ChatUtils.isEmptyMessage(Tnttag.customizationfile.getString(path))) {
            return;
        }
        player.sendMessage(ChatUtils.colorize(Tnttag.customizationfile.getString(path)).replace("{player}", player.getName()).replace("{arena}", arena.getName()));
    }

    public static void sendArenaMessage(Arena arena, Player player, String path) {
        if (ChatUtils.isEmptyMessage(Tnttag.customizationfile.getString(path))) {
            return;
        }
        arena.broadcastMessage(ChatUtils.colorize(Tnttag.customizationfile.getString(path)).replace("{player}", player.getName()).replace("{currentPlayers}", String.valueOf(arena.getPlayers().size())).replace("{maxPlayers}", String.valueOf(arena.getMaxPlayers())).replace("{seconds}", String.valueOf(arena.getSeconds())));
    }

    public static void sendArenaMessage(Arena arena, String path) {
        if (ChatUtils.isEmptyMessage(Tnttag.customizationfile.getString(path))) {
            return;
        }
        arena.broadcastMessage(ChatUtils.colorize(Tnttag.customizationfile.getString(path)).replace("{currentPlayers}", String.valueOf(arena.getPlayers().size())).replace("{maxPlayers}", String.valueOf(arena.getMaxPlayers())).replace("{seconds}", String.valueOf(arena.getSeconds())).replace("{arena}", arena.getName()));
    }

    public static void sendCustomMessage(Player player, String msg) {
        if (ChatUtils.isEmptyMessage(Tnttag.customizationfile.getString(msg))) {
            return;
        }
        player.sendMessage(ChatUtils.colorize(msg).replace("{player}", player.getName()));
    }

    public static boolean isEmptyMessage(String message) {
        return message.equals("");
    }
}

