/*
 * Decompiled with CFR 0.152.
 */
package ga.juriantech.tnttag.objects;

import ga.juriantech.tnttag.Tnttag;
import ga.juriantech.tnttag.utils.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import org.bukkit.entity.Player;

public class PlayerData {
    private Player player;

    public PlayerData(Player player) {
        this.player = player;
    }

    public void setWins(int wins) {
        Tnttag.playerdatafile.set(this.player.getUniqueId() + ".wins", (Object)wins);
        this.savePlayerDataFile();
    }

    public Integer getWins() {
        if (Tnttag.playerdatafile.getInt(this.player.getUniqueId() + ".wins") == null) {
            return 0;
        }
        return Tnttag.playerdatafile.getInt(this.player.getUniqueId() + ".wins");
    }

    public void setTimesTagged(int timestagged) {
        Tnttag.playerdatafile.set(this.player.getUniqueId() + ".timestagged", (Object)timestagged);
        this.savePlayerDataFile();
    }

    public Integer getTimesTagged() {
        if (Tnttag.playerdatafile.getInt(this.player.getUniqueId() + ".timestagged") == null) {
            return 0;
        }
        return Tnttag.playerdatafile.getInt(this.player.getUniqueId() + ".timestagged");
    }

    public void setTags(int tags) {
        Tnttag.playerdatafile.set(this.player.getUniqueId() + ".tags", (Object)tags);
        this.savePlayerDataFile();
    }

    public Integer getTags() {
        if (Tnttag.playerdatafile.getInt(this.player.getUniqueId() + ".tags") == null) {
            return 0;
        }
        return Tnttag.playerdatafile.getInt(this.player.getUniqueId() + ".tags");
    }

    public TreeMap<UUID, Integer> getWinsData() {
        TreeMap<UUID, Integer> winsData = new TreeMap<UUID, Integer>();
        for (String route : Tnttag.playerdatafile.getRoutesAsStrings(false)) {
            if (Tnttag.playerdatafile.getInt(route + ".wins") == null) continue;
            int wins = Tnttag.playerdatafile.getInt(route + ".wins");
            winsData.put(UUID.fromString(route), wins);
        }
        return winsData;
    }

    public TreeMap<UUID, Integer> getTimesTaggedData() {
        TreeMap<UUID, Integer> timesTaggedData = new TreeMap<UUID, Integer>();
        for (String route : Tnttag.playerdatafile.getRoutesAsStrings(false)) {
            if (Tnttag.playerdatafile.getInt(route + ".timestagged") == null) continue;
            int kills = Tnttag.playerdatafile.getInt(route + ".timestagged");
            timesTaggedData.put(UUID.fromString(route), kills);
        }
        return timesTaggedData;
    }

    public TreeMap<UUID, Integer> getTagsData() {
        TreeMap<UUID, Integer> tagsData = new TreeMap<UUID, Integer>();
        for (String route : Tnttag.playerdatafile.getRoutesAsStrings(false)) {
            if (Tnttag.playerdatafile.getInt(route + ".tags") == null) continue;
            int deaths = Tnttag.playerdatafile.getInt(route + ".tags");
            tagsData.put(UUID.fromString(route), deaths);
        }
        return tagsData;
    }

    public ArrayList<UUID> getTopThreePlayers(TreeMap<UUID, Integer> data) {
        if (data.size() == 0) {
            return new ArrayList<UUID>();
        }
        ArrayList<Integer> integerArrayList = new ArrayList<Integer>();
        for (Map.Entry<UUID, Integer> entry : data.entrySet()) {
            integerArrayList.add(entry.getValue());
        }
        Collections.sort(integerArrayList);
        ArrayList<UUID> topThreePlayers = new ArrayList<UUID>();
        for (Integer integer : integerArrayList) {
            UUID uuid = Utils.getKeyByValue(data, integer);
            topThreePlayers.add(uuid);
        }
        return topThreePlayers;
    }

    private void savePlayerDataFile() {
        try {
            Tnttag.playerdatafile.save();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

