/*
 * Decompiled with CFR 0.152.
 */
package ga.juriantech.tnttag.managers;

import ga.juriantech.tnttag.Arena;
import ga.juriantech.tnttag.Tnttag;
import ga.juriantech.tnttag.objects.PlayerData;
import ga.juriantech.tnttag.utils.ChatUtils;
import ga.juriantech.tnttag.utils.ParticleUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class CountdownManager {
    private Tnttag plugin = Tnttag.getInstance();
    private Arena arena;
    private List<Integer> timesToBroadcast;
    private ArrayList<String> potionEffects = new ArrayList();

    public CountdownManager(Arena arena) {
        this.arena = arena;
        this.timesToBroadcast = new ArrayList<Integer>();
        this.potionEffects = arena.getPotionEffects();
        this.timesToBroadcast.add(50);
        this.timesToBroadcast.add(40);
        this.timesToBroadcast.add(30);
        this.timesToBroadcast.add(20);
        this.timesToBroadcast.add(15);
        this.timesToBroadcast.add(10);
        this.timesToBroadcast.add(5);
        this.timesToBroadcast.add(4);
        this.timesToBroadcast.add(3);
        this.timesToBroadcast.add(2);
        this.timesToBroadcast.add(1);
    }

    public void startGame(int seconds1) {
        if (!this.arena.isRunningCountdown() && this.arena.getPlayers().size() >= this.arena.getMinPlayers()) {
            this.arena.setSeconds(seconds1);
            this.arena.setRunningCountdown(true);
            this.arena.setTaskID(Bukkit.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    if (CountdownManager.this.timesToBroadcast.contains(CountdownManager.this.arena.getSeconds())) {
                        ChatUtils.sendArenaMessage(CountdownManager.this.arena, "arena.cooldown-message");
                        for (Player player : CountdownManager.this.arena.getPlayers()) {
                            player.setLevel(CountdownManager.this.arena.getSeconds());
                        }
                    }
                    if (CountdownManager.this.arena.getSeconds() == 0) {
                        Bukkit.getScheduler().cancelTask(CountdownManager.this.arena.getTaskID());
                        CountdownManager.this.arena.setState(Arena.GameState.INGAME);
                        Location startLoc = CountdownManager.this.arena.getStartLocation();
                        for (Player player : CountdownManager.this.arena.getPlayers()) {
                            player.teleport(startLoc);
                        }
                        ChatUtils.sendArenaMessage(CountdownManager.this.arena, "arena.tagger-released");
                        CountdownManager.this.pickPlayers();
                        CountdownManager.this.startRound();
                    }
                    int seconds = CountdownManager.this.arena.getSeconds();
                    CountdownManager.this.arena.setSeconds(seconds - 1);
                }
            }, 20L, 20L));
        }
    }

    protected void startRound() {
        this.arena.setSeconds(this.arena.getPlayers().size() <= this.arena.getMaxPlayers() ? 30 : 50);
        this.arena.setTaskID(Bukkit.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                for (Player player : CountdownManager.this.arena.getPlayers()) {
                    player.setLevel(CountdownManager.this.arena.getSeconds());
                }
                if (CountdownManager.this.arena.getSeconds() == 0) {
                    Bukkit.getScheduler().cancelTask(CountdownManager.this.arena.getTaskID());
                    if (CountdownManager.this.arena.getPlayers().size() == 2) {
                        CountdownManager.this.endRound();
                        CountdownManager.this.endGame();
                    } else if (CountdownManager.this.arena.getPlayers().size() > 2) {
                        CountdownManager.this.endRound();
                        CountdownManager.this.startNewRound();
                    }
                }
                int seconds = CountdownManager.this.arena.getSeconds();
                CountdownManager.this.arena.setSeconds(seconds - 1);
            }
        }, 20L, 20L));
    }

    private void startNewRound() {
        this.arena.setSeconds(5);
        this.arena.setTaskID(Bukkit.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                if (CountdownManager.this.arena.getSeconds() == 0) {
                    Bukkit.getScheduler().cancelTask(CountdownManager.this.arena.getTaskID());
                    CountdownManager.this.startRound();
                    Location startLoc = CountdownManager.this.arena.getStartLocation();
                    for (Player player : CountdownManager.this.arena.getPlayers()) {
                        player.teleport(startLoc);
                    }
                    ChatUtils.sendArenaMessage(CountdownManager.this.arena, "arena.tagger-released");
                    CountdownManager.this.pickPlayers();
                }
                int seconds = CountdownManager.this.arena.getSeconds();
                CountdownManager.this.arena.setSeconds(seconds - 1);
            }
        }, 20L, 20L));
    }

    private void pickPlayers() {
        Random random = new Random();
        int randomint = random.nextInt(this.arena.getPlayers().size());
        Player player = this.arena.getPlayers().get(randomint);
        this.arena.getTNTPlayers().add(player);
        ChatUtils.sendMessage(player, "player.is-tagger");
        player.getInventory().setHelmet(new ItemStack(Material.TNT, 1));
        player.getInventory().setItem(0, new ItemStack(Material.TNT, 1));
        for (Player p : this.arena.getPlayers()) {
            String[] parts;
            if (!this.arena.getTNTPlayers().contains(p)) {
                this.arena.getAlivePlayers().add(p);
                block1: for (Player ppl : this.arena.getAlivePlayers()) {
                    for (String potionEffect : this.potionEffects) {
                        parts = potionEffect.split(":");
                        if (parts[0] == null || parts[1] == null || parts[2] == null) {
                            Bukkit.getLogger().severe(ChatUtils.colorize("&4[TNT-Tag] &6Some of the potionEffects from arena " + this.arena.getName() + " are misconfigured, the effects are not given."));
                            continue block1;
                        }
                        if (!parts[2].equalsIgnoreCase("ALIVEPLAYERS")) continue;
                        ppl.addPotionEffect(new PotionEffect(PotionEffectType.getByName((String)parts[0]), Integer.MAX_VALUE, Integer.parseInt(parts[1])));
                    }
                }
            }
            block3: for (Player ppl : this.arena.getTNTPlayers()) {
                for (String potionEffect : this.potionEffects) {
                    parts = potionEffect.split(":");
                    if (parts[0] == null || parts[1] == null || parts[2] == null) {
                        Bukkit.getLogger().severe(ChatUtils.colorize("&4[TNT-Tag] &6Some of the potionEffects from arena " + this.arena.getName() + " are misconfigured, the effects are not given."));
                        continue block3;
                    }
                    if (!parts[2].equalsIgnoreCase("TNTPLAYERS")) continue;
                    ppl.addPotionEffect(new PotionEffect(PotionEffectType.getByName((String)parts[0]), Integer.MAX_VALUE, Integer.parseInt(parts[1])));
                }
            }
        }
    }

    private void endRound() {
        ConsoleCommandSender console;
        for (Player player : this.arena.getTNTPlayers()) {
            for (String cmd : Tnttag.configfile.getStringList("round-finish-commands.tntplayers")) {
                console = Bukkit.getConsoleSender();
                Bukkit.dispatchCommand((CommandSender)console, (String)cmd.replace("%player%", player.getName()));
            }
            World world = player.getWorld();
            world.createExplosion(player.getLocation(), 0.5f, false, false);
            ChatUtils.sendArenaMessage(this.arena, player, "arena.player-blew-up");
            player.getInventory().setHelmet(new ItemStack(Material.AIR, 1));
            player.getInventory().setItem(0, new ItemStack(Material.AIR, 1));
            this.arena.getPlayers().remove(player);
            ChatUtils.sendMessage(player, "player.lost-game");
            player.teleport(this.arena.getLobbyLocation());
        }
        ChatUtils.sendArenaMessage(this.arena, "arena.round-ended");
        for (Player player : this.arena.getPlayers()) {
            for (String cmd : Tnttag.configfile.getStringList("round-finish-commands.aliveplayers")) {
                console = Bukkit.getConsoleSender();
                Bukkit.dispatchCommand((CommandSender)console, (String)cmd.replace("%player%", player.getName()));
            }
            ParticleUtils.Firework(player.getLocation(), 0);
            for (PotionEffect effect : player.getActivePotionEffects()) {
                player.removePotionEffect(effect.getType());
            }
        }
    }

    private void endGame() {
        ConsoleCommandSender console;
        for (Player player : this.arena.getTNTPlayers()) {
            for (String cmd : Tnttag.configfile.getStringList("arena-finish-commands.tntplayers")) {
                console = Bukkit.getConsoleSender();
                Bukkit.dispatchCommand((CommandSender)console, (String)cmd.replace("%player%", player.getName()));
            }
        }
        for (Player player : this.arena.getAlivePlayers()) {
            for (String cmd : Tnttag.configfile.getStringList("arena-finish-commands.aliveplayers")) {
                console = Bukkit.getConsoleSender();
                Bukkit.dispatchCommand((CommandSender)console, (String)cmd.replace("%player%", player.getName()));
            }
            PlayerData playerData = new PlayerData(player);
            int oldWins = playerData.getWins();
            playerData.setWins(oldWins + 1);
        }
        ParticleUtils.Firework(this.arena.getAlivePlayers().get(0).getLocation(), 0);
        ChatUtils.sendArenaMessage(this.arena, this.arena.getAlivePlayers().get(0), "arena.player-win");
        this.arena.setRunningCountdown(false);
        this.arena.getAlivePlayers().clear();
        this.arena.getTNTPlayers().clear();
        if (!this.arena.getPlayers().isEmpty()) {
            for (Player player : this.arena.getPlayers()) {
                this.arena.removePlayer(player);
                this.arena.setState(Arena.GameState.STARTING);
                ChatUtils.sendMessage(player, "player.game-ended");
                player.teleport(this.arena.getLobbyLocation());
            }
        }
    }
}

