/*
 * Decompiled with CFR 0.152.
 */
package ga.juriantech.tnttag.managers;

import ga.juriantech.tnttag.Arena;
import ga.juriantech.tnttag.Tnttag;
import java.io.IOException;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class ArenaManager {
    private Tnttag plugin = Tnttag.getInstance();
    public ArrayList<Arena> arenaObjects = new ArrayList();

    public Arena getArena(String name) {
        for (Arena arena : this.arenaObjects) {
            if (!arena.getName().equals(name)) continue;
            return arena;
        }
        return null;
    }

    public void deleteArena(String name) {
        if (this.getArena(name) != null) {
            Arena arena = this.getArena(name);
            this.arenaObjects.remove(arena);
        }
    }

    public boolean playerIsInArena(Player player) {
        for (Arena arena : this.arenaObjects) {
            if (!arena.getPlayers().contains(player)) continue;
            return true;
        }
        return false;
    }

    public Arena getPlayerArena(Player player) {
        for (Arena arena : this.arenaObjects) {
            if (!arena.getPlayers().contains(player)) continue;
            return arena;
        }
        return null;
    }

    public ArrayList<Arena> getArenaObjects() {
        return this.arenaObjects;
    }

    public void saveArenasToFile() {
        int arenas = 0;
        if (this.arenaObjects == null) {
            return;
        }
        for (Arena arena : this.arenaObjects) {
            ++arenas;
            Tnttag.arenasfile.set(arena.getName() + ".startLocation.world", (Object)arena.getStartLocation().getWorld().getName());
            Tnttag.arenasfile.set(arena.getName() + ".startLocation.x", (Object)arena.getStartLocation().getX());
            Tnttag.arenasfile.set(arena.getName() + ".startLocation.y", (Object)arena.getStartLocation().getY());
            Tnttag.arenasfile.set(arena.getName() + ".startLocation.z", (Object)arena.getStartLocation().getZ());
            Tnttag.arenasfile.set(arena.getName() + ".lobbyLocation.world", (Object)arena.getLobbyLocation().getWorld().getName());
            Tnttag.arenasfile.set(arena.getName() + ".lobbyLocation.x", (Object)arena.getLobbyLocation().getX());
            Tnttag.arenasfile.set(arena.getName() + ".lobbyLocation.y", (Object)arena.getLobbyLocation().getY());
            Tnttag.arenasfile.set(arena.getName() + ".lobbyLocation.z", (Object)arena.getLobbyLocation().getZ());
            Tnttag.arenasfile.set(arena.getName() + ".maxPlayers", (Object)arena.getMaxPlayers());
            Tnttag.arenasfile.set(arena.getName() + ".minPlayers", (Object)arena.getMinPlayers());
            Tnttag.arenasfile.set(arena.getName() + ".potionEffects", arena.getPotionEffects());
        }
        try {
            Tnttag.arenasfile.save();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Bukkit.getLogger().info("Saved " + arenas + " TNT-Tag arena(s)!");
    }

    public void loadArenasFromFile() {
        int arenas = 0;
        for (String route : Tnttag.arenasfile.getRoutesAsStrings(false)) {
            ++arenas;
            String startlocworld = Tnttag.arenasfile.getString(route + ".startLocation.world");
            int startlocx = Tnttag.arenasfile.getInt(route + ".startLocation.x");
            int startlocy = Tnttag.arenasfile.getInt(route + ".startLocation.y");
            int startlocz = Tnttag.arenasfile.getInt(route + ".startLocation.z");
            String lobbylocworld = Tnttag.arenasfile.getString(route + ".lobbyLocation.world");
            int lobbylocx = Tnttag.arenasfile.getInt(route + ".lobbyLocation.x");
            int lobbylocy = Tnttag.arenasfile.getInt(route + ".lobbyLocation.y");
            int lobbylocz = Tnttag.arenasfile.getInt(route + ".lobbyLocation.z");
            int maxplayers = Tnttag.arenasfile.getInt(route + ".maxPlayers");
            int minplayers = Tnttag.arenasfile.getInt(route + ".minPlayers");
            ArrayList<String> potionEffects = new ArrayList<String>();
            for (String potionEffect : Tnttag.arenasfile.getStringList(route + ".potionEffects")) {
                potionEffects.add(potionEffect);
            }
            World startLocWorld = Bukkit.getWorld((String)startlocworld);
            World lobbyLocWorld = Bukkit.getWorld((String)lobbylocworld);
            if (startLocWorld == null || lobbyLocWorld == null) {
                Bukkit.getLogger().severe("[Tnt-tag] Error: a world from arena " + route + " is not loaded, disabling the arena...");
                return;
            }
            Location startLoc = new Location(Bukkit.getWorld((String)startlocworld), (double)startlocx, (double)startlocy, (double)startlocz);
            Location lobbyLoc = new Location(Bukkit.getWorld((String)lobbylocworld), (double)lobbylocx, (double)lobbylocy, (double)lobbylocz);
            new Arena(route, startLoc, lobbyLoc, minplayers, maxplayers, potionEffects);
        }
        Bukkit.getLogger().info("Loaded " + arenas + " TNT-Tag arena(s)!");
    }
}

