/*
 * Decompiled with CFR 0.152.
 */
package ga.juriantech.tnttag.listeners;

import ga.juriantech.tnttag.Arena;
import ga.juriantech.tnttag.Tnttag;
import ga.juriantech.tnttag.objects.PlayerData;
import ga.juriantech.tnttag.utils.ChatUtils;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class EntityDamageByEntityListener
implements Listener {
    private Tnttag plugin = Tnttag.getInstance();

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        if (event.getEntity() instanceof Player && event.getDamager() instanceof Player) {
            Player damager = (Player)event.getDamager();
            Player victim = (Player)event.getEntity();
            if (this.plugin.getArenaManager().playerIsInArena(damager) && this.plugin.getArenaManager().playerIsInArena(victim)) {
                Arena arena;
                event.setCancelled(true);
                Arena victimarena = this.plugin.getArenaManager().getPlayerArena(victim);
                Arena damagerarena = this.plugin.getArenaManager().getPlayerArena(damager);
                if (victimarena.getName().equals(damagerarena.getName()) && (arena = victimarena).getTNTPlayers().contains(damager)) {
                    for (PotionEffect effect : damager.getActivePotionEffects()) {
                        damager.removePotionEffect(effect.getType());
                    }
                    for (PotionEffect effect : victim.getActivePotionEffects()) {
                        victim.removePotionEffect(effect.getType());
                    }
                    PlayerData playerDataDamager = new PlayerData(damager);
                    int oldTags = playerDataDamager.getTags();
                    playerDataDamager.setTags(oldTags + 1);
                    arena.getTNTPlayers().remove(damager);
                    damager.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, Integer.MAX_VALUE, 1));
                    damager.getInventory().setHelmet(new ItemStack(Material.AIR));
                    damager.getInventory().setItem(0, new ItemStack(Material.AIR, 1));
                    arena.getAlivePlayers().add(damager);
                    ChatUtils.sendMessage(damager, "player.tagger-removed");
                    PlayerData playerDataVictim = new PlayerData(victim);
                    int oldTimesTagged = playerDataVictim.getTimesTagged();
                    playerDataVictim.setTimesTagged(oldTimesTagged + 1);
                    arena.getAlivePlayers().remove(victim);
                    arena.getTNTPlayers().add(victim);
                    victim.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, Integer.MAX_VALUE, 2));
                    victim.getInventory().setHelmet(new ItemStack(Material.TNT));
                    victim.getInventory().setItem(0, new ItemStack(Material.TNT, 1));
                    victim.sendMessage(ChatUtils.colorize(Tnttag.customizationfile.getString("player.tagged")).replace("{player}", damager.getName()));
                }
            }
        }
    }
}

