/*
 * Decompiled with CFR 0.152.
 */
package ga.juriantech.tnttag.handlers;

import ga.juriantech.tnttag.Arena;
import ga.juriantech.tnttag.Tnttag;
import ga.juriantech.tnttag.utils.ChatUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SetupCommandHandler {
    private Tnttag plugin = Tnttag.getInstance();
    private HashMap<UUID, String> lastMessages = new HashMap();
    private HashMap<UUID, String> setupStep = new HashMap();
    private HashMap<Player, String> arenaName = new HashMap();
    private HashMap<Player, Integer> minPlayers = new HashMap();
    private HashMap<Player, Integer> maxPlayers = new HashMap();
    private HashMap<Player, Location> lobbyLocation = new HashMap();
    private HashMap<Player, Location> startLocation = new HashMap();

    public void start(Player player) {
        this.clearChat(player);
        ChatUtils.sendMessage(player, "setup.introduction");
        ChatUtils.sendMessage(player, "setup.start");
        ChatUtils.sendMessage(player, "setup.enter-name");
        this.setupStep.put(player.getUniqueId(), "enter-name");
    }

    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        String message = event.getMessage();
        if (this.lastMessages.entrySet().size() == 20 || this.lastMessages.entrySet().size() > 20) {
            UUID firstEntry = (UUID)((Map.Entry)this.lastMessages.entrySet().stream().findFirst().get()).getKey();
            this.lastMessages.remove(firstEntry);
        }
        this.lastMessages.put(player.getUniqueId(), message);
        if (this.setupStep.containsKey(player.getUniqueId())) {
            event.setCancelled(true);
            if (message.equals("cancel")) {
                this.cancel(player);
            }
            if (this.setupStep.get(player.getUniqueId()).equals("enter-name")) {
                this.setupStep.remove(player.getUniqueId());
                this.arenaName.put(player, message);
                this.clearChat(player);
                ChatUtils.sendMessage(player, "setup.name-entered");
                ChatUtils.sendMessage(player, "setup.enter-minPlayers");
                this.setupStep.put(player.getUniqueId(), "enter-minPlayers");
                return;
            }
            if (this.setupStep.get(player.getUniqueId()).equals("enter-minPlayers")) {
                int minPlayersInteger;
                try {
                    minPlayersInteger = Integer.parseInt(message);
                }
                catch (NumberFormatException e) {
                    ChatUtils.sendMessage(player, "general.invalid-number");
                    return;
                }
                if (minPlayersInteger < 2) {
                    ChatUtils.sendMessage(player, "setup.minPlayers-too-low");
                    return;
                }
                this.setupStep.remove(player.getUniqueId());
                this.minPlayers.put(player, minPlayersInteger);
                this.clearChat(player);
                ChatUtils.sendMessage(player, "setup.minPlayers-entered");
                ChatUtils.sendMessage(player, "setup.enter-maxPlayers");
                this.setupStep.put(player.getUniqueId(), "enter-maxPlayers");
                return;
            }
            if (this.setupStep.get(player.getUniqueId()).equals("enter-maxPlayers")) {
                int maxPlayersInteger = 0;
                try {
                    maxPlayersInteger = Integer.parseInt(message);
                }
                catch (NumberFormatException e) {
                    ChatUtils.sendMessage(player, "general.invalid-number");
                }
                this.setupStep.remove(player.getUniqueId());
                this.maxPlayers.put(player, maxPlayersInteger);
                this.clearChat(player);
                ChatUtils.sendMessage(player, "setup.maxPlayers-entered");
                ChatUtils.sendMessage(player, "setup.set-lobbyLocation");
                this.setupStep.put(player.getUniqueId(), "set-lobbyLocation");
                return;
            }
            if (this.setupStep.get(player.getUniqueId()).equals("set-lobbyLocation") && message.equals("setlobby")) {
                this.setupStep.remove(player.getUniqueId());
                this.lobbyLocation.put(player, player.getLocation());
                this.clearChat(player);
                ChatUtils.sendMessage(player, "setup.lobbyLocation-set");
                ChatUtils.sendMessage(player, "setup.set-startLocation");
                this.setupStep.put(player.getUniqueId(), "set-startLocation");
                return;
            }
            if (this.setupStep.get(player.getUniqueId()).equals("set-startLocation") && message.equals("setstart")) {
                this.startLocation.put(player, player.getLocation());
                this.clearChat(player);
                ChatUtils.sendMessage(player, "setup.startLocation-set");
                this.createArena(player);
            }
        }
    }

    public void cancel(Player player) {
        ChatUtils.sendMessage(player, "setup.cancelled");
        this.removeSetupData(player);
        this.clearChat(player);
        this.returnChat(player);
    }

    public void clearChat(Player player) {
        for (int count = 0; count < 20; ++count) {
            player.sendMessage("");
        }
    }

    public void removeSetupData(Player player) {
        try {
            this.setupStep.remove(player.getUniqueId());
            this.arenaName.remove(player);
            this.minPlayers.remove(player);
            this.maxPlayers.remove(player);
            this.lobbyLocation.remove(player);
            this.startLocation.remove(player);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void createArena(Player player) {
        String arenaname = this.arenaName.get(player);
        int minplayers = this.minPlayers.get(player);
        int maxplayers = this.maxPlayers.get(player);
        Location lobbylocation = this.lobbyLocation.get(player);
        Location startlocation = this.startLocation.get(player);
        ArrayList<String> defaultPotionEffects = new ArrayList<String>();
        defaultPotionEffects.add("SPEED:2:ALIVEPLAYERS");
        defaultPotionEffects.add("SPEED:3:TNTPLAYERS");
        defaultPotionEffects.add("SLOW_FALLING:1:TNTPLAYERS");
        defaultPotionEffects.add("SLOW_FALLING:1:ALIVEPLAYERS");
        defaultPotionEffects.add("HEALTH_BOOST:1:TNTPLAYERS");
        defaultPotionEffects.add("HEALTH_BOOST:1:ALIVEPLAYERS");
        Arena arena = new Arena(arenaname, startlocation, lobbylocation, maxplayers, minplayers, defaultPotionEffects);
        ChatUtils.sendMessage(arena, player, "setup.finished");
        this.returnChat(player);
        this.removeSetupData(player);
    }

    public void returnChat(final Player player) {
        ChatUtils.sendMessage(player, "setup.returning-chat");
        new BukkitRunnable(){

            public void run() {
                for (Map.Entry entry : SetupCommandHandler.this.lastMessages.entrySet()) {
                    UUID playeruuid = (UUID)entry.getKey();
                    player.sendMessage(ChatUtils.colorize("&3" + Bukkit.getOfflinePlayer((UUID)playeruuid).getName() + ": &2" + entry.getValue()));
                }
                ChatUtils.sendMessage(player, "setup.chat-restored");
            }
        }.runTaskLater((Plugin)this.plugin, 100L);
    }
}

