/*
 * Decompiled with CFR 0.152.
 */
package ga.juriantech.tnttag.commands;

import ga.juriantech.acf.BaseCommand;
import ga.juriantech.acf.annotation.CommandAlias;
import ga.juriantech.acf.annotation.CommandPermission;
import ga.juriantech.acf.annotation.Default;
import ga.juriantech.acf.annotation.Subcommand;
import ga.juriantech.acf.annotation.Syntax;
import ga.juriantech.tnttag.Arena;
import ga.juriantech.tnttag.Tnttag;
import ga.juriantech.tnttag.managers.ArenaManager;
import ga.juriantech.tnttag.objects.PlayerData;
import ga.juriantech.tnttag.utils.ChatUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

@CommandAlias(value="tnttag|tt")
public class TnttagCommand
extends BaseCommand {
    Tnttag plugin = Tnttag.getInstance();
    ArenaManager arenaManager = this.plugin.getArenaManager();

    @Subcommand(value="help")
    @Default
    @CommandPermission(value="tnttag.help")
    public void onHelp(Player player) {
        List<String> helpmenu = Tnttag.customizationfile.getStringList("help-menu");
        for (String message : helpmenu) {
            ChatUtils.sendCustomMessage(player, message);
        }
    }

    @Subcommand(value="join")
    @CommandPermission(value="tnttag.join")
    @Syntax(value="<arena>")
    public void onJoin(Player player, String arenaname) {
        if (this.arenaManager.playerIsInArena(player)) {
            ChatUtils.sendMessage(player, "player.already-in-game");
            return;
        }
        if (this.arenaManager.getArena(arenaname) != null) {
            Arena arena = this.arenaManager.getArena(arenaname);
            arena.addPlayer(player);
        } else {
            ChatUtils.sendMessage(player, "commands.invalid-arena");
        }
    }

    @Subcommand(value="leave")
    public void onLeave(Player player) {
        if (this.arenaManager.playerIsInArena(player)) {
            Arena arena = this.arenaManager.getPlayerArena(player);
            arena.removePlayer(player);
        } else {
            ChatUtils.sendMessage(player, "commands.not-in-arena");
        }
    }

    @Subcommand(value="list")
    @CommandPermission(value="tnttag.list")
    public void onList(Player player) {
        ArrayList<String> arenas = new ArrayList<String>();
        for (Arena arena : this.arenaManager.getArenaObjects()) {
            arenas.add(arena.getName());
        }
        player.sendMessage(ChatUtils.colorize(Tnttag.customizationfile.getString("commands.available-arenas")).replace("{arenas}", arenas.toString()));
    }

    @Subcommand(value="create")
    @CommandPermission(value="tnttag.create")
    public void onCreate(Player player) {
        this.plugin.getSetupCommandHandler().start(player);
    }

    @Subcommand(value="delete")
    @CommandPermission(value="tnttag.delete")
    @Syntax(value="<arena>")
    public void onDelete(Player player, String name) {
        if (this.arenaManager.getArena(name) != null) {
            Arena arena = this.arenaManager.getArena(name);
            ChatUtils.sendMessage(arena, player, "commands.arena-deleted");
            this.arenaManager.deleteArena(name);
        } else {
            ChatUtils.sendMessage(player, "commands.invalid-arena");
        }
    }

    @Subcommand(value="reload")
    @CommandPermission(value="tnttag.reload")
    public void onReload(Player player) throws IOException {
        Tnttag.customizationfile.save();
        Tnttag.customizationfile.reload();
        ChatUtils.sendMessage(player, "commands.files-reloaded");
    }

    @Subcommand(value="stats")
    @CommandPermission(value="tnttag.stats")
    public void onStats(Player player) {
        ChatUtils.sendMessage(player, "commands.stats-header");
        ChatUtils.sendMessage(player, "commands.stats-wins");
        ChatUtils.sendMessage(player, "commands.stats-timestagged");
        ChatUtils.sendMessage(player, "commands.stats-tags");
        ChatUtils.sendMessage(player, "commands.stats-footer");
    }

    @Subcommand(value="top")
    @CommandPermission(value="tnttag.top")
    @Syntax(value="<wins/kills/deaths>")
    public void onTop(Player player, String type) {
        PlayerData playerData = new PlayerData(player);
        TreeMap<UUID, Integer> topWins = playerData.getWinsData();
        ArrayList<UUID> topThreeWinPlayers = playerData.getTopThreePlayers(topWins);
        TreeMap<UUID, Integer> topTimesTagged = playerData.getTimesTaggedData();
        ArrayList<UUID> topThreeTimesTaggedPlayers = playerData.getTopThreePlayers(topTimesTagged);
        TreeMap<UUID, Integer> topTags = playerData.getTagsData();
        ArrayList<UUID> topThreeTagsPlayers = playerData.getTopThreePlayers(topTags);
        if (type.equals("wins")) {
            UUID win1 = topThreeWinPlayers.size() > 0 ? topThreeWinPlayers.get(0) : null;
            UUID win2 = topThreeWinPlayers.size() > 1 ? topThreeWinPlayers.get(1) : null;
            UUID win3 = topThreeWinPlayers.size() > 2 ? topThreeWinPlayers.get(2) : null;
            player.sendMessage(ChatUtils.colorize(Tnttag.customizationfile.getString("commands.top-wins")));
            if (win1 != null && win2 != null && win3 != null) {
                player.sendMessage(ChatUtils.colorize("&6\u272b 1. &3" + Bukkit.getOfflinePlayer((UUID)win1).getName() + "&6 - &3" + topWins.get(win1)));
                player.sendMessage(ChatUtils.colorize("&6\u272b 2. &3" + Bukkit.getOfflinePlayer((UUID)win2).getName() + "&6 - &3" + topWins.get(win2)));
                player.sendMessage(ChatUtils.colorize("&6\u272b 3. &3" + Bukkit.getOfflinePlayer((UUID)win3).getName() + "&6 - &3" + topWins.get(win3)));
                player.sendMessage(ChatUtils.colorize(Tnttag.customizationfile.getString("commands.top-footer")));
            } else {
                ChatUtils.sendMessage(player, "general.not-enough-stats");
            }
        } else if (type.equals("timestagged")) {
            UUID timestagged1 = topThreeTimesTaggedPlayers.size() > 0 ? topThreeTimesTaggedPlayers.get(0) : null;
            UUID timestagged2 = topThreeTimesTaggedPlayers.size() > 1 ? topThreeTimesTaggedPlayers.get(1) : null;
            UUID timestagged3 = topThreeTimesTaggedPlayers.size() > 2 ? topThreeTimesTaggedPlayers.get(2) : null;
            player.sendMessage(ChatUtils.colorize(Tnttag.customizationfile.getString("commands.top-timestagged")));
            if (timestagged1 != null && timestagged2 != null && timestagged3 != null) {
                player.sendMessage(ChatUtils.colorize("&6\u272b 1. &3" + Bukkit.getOfflinePlayer((UUID)timestagged1).getName() + "&6 - &3" + topTimesTagged.get(timestagged1)));
                player.sendMessage(ChatUtils.colorize("&6\u272b 2. &3" + Bukkit.getOfflinePlayer((UUID)timestagged2).getName() + "&6 - &3" + topTimesTagged.get(timestagged2)));
                player.sendMessage(ChatUtils.colorize("&6\u272b 3. &3" + Bukkit.getOfflinePlayer((UUID)timestagged3).getName() + "&6 - &3" + topTimesTagged.get(timestagged3)));
                player.sendMessage(ChatUtils.colorize(Tnttag.customizationfile.getString("commands.top-footer")));
            } else {
                ChatUtils.sendMessage(player, "general.not-enough-stats");
            }
        } else if (type.equals("tags")) {
            UUID tags1 = topThreeTagsPlayers.size() > 0 ? topThreeTagsPlayers.get(0) : null;
            UUID tags2 = topThreeTagsPlayers.size() > 1 ? topThreeTagsPlayers.get(1) : null;
            UUID tags3 = topThreeTagsPlayers.size() > 2 ? topThreeTagsPlayers.get(2) : null;
            player.sendMessage(ChatUtils.colorize(Tnttag.customizationfile.getString("commands.top-tags")));
            if (tags1 != null && tags2 != null && tags3 != null) {
                player.sendMessage(ChatUtils.colorize("&6\u272b 1. &3" + Bukkit.getOfflinePlayer((UUID)tags1).getName() + "&6 - &3" + topTags.get(tags1)));
                player.sendMessage(ChatUtils.colorize("&6\u272b 2. &3" + Bukkit.getOfflinePlayer((UUID)tags2).getName() + "&6 - &3" + topTags.get(tags2)));
                player.sendMessage(ChatUtils.colorize("&6\u272b 3. &3" + Bukkit.getOfflinePlayer((UUID)tags3).getName() + "&6 - &3" + topTags.get(tags3)));
                player.sendMessage(ChatUtils.colorize(Tnttag.customizationfile.getString("commands.top-footer")));
            } else {
                ChatUtils.sendMessage(player, "general.not-enough-stats");
            }
        } else {
            player.sendMessage(ChatUtils.colorize(Tnttag.customizationfile.getString("general.invalid-stat-type")));
        }
    }
}

