/*
 * Decompiled with CFR 0.152.
 */
package ga.juriantech.tnttag;

import ga.juriantech.acf.BukkitCommandManager;
import ga.juriantech.libs.YamlDocument;
import ga.juriantech.tnttag.checkers.UpdateChecker;
import ga.juriantech.tnttag.commands.TnttagCommand;
import ga.juriantech.tnttag.handlers.SetupCommandHandler;
import ga.juriantech.tnttag.listeners.AsyncPlayerChatListener;
import ga.juriantech.tnttag.listeners.BlockBreakListener;
import ga.juriantech.tnttag.listeners.BlockPlaceListener;
import ga.juriantech.tnttag.listeners.EntityDamageByEntityListener;
import ga.juriantech.tnttag.listeners.InventoryClickListener;
import ga.juriantech.tnttag.listeners.PlayerInteractListener;
import ga.juriantech.tnttag.listeners.PlayerQuitListener;
import ga.juriantech.tnttag.managers.ArenaManager;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Tnttag
extends JavaPlugin {
    private static Tnttag instance;
    private Logger logger = Bukkit.getLogger();
    private ArenaManager arenaManager;
    public static YamlDocument arenasfile;
    public static YamlDocument customizationfile;
    public static YamlDocument configfile;
    public static YamlDocument playerdatafile;
    private SetupCommandHandler setupCommandHandler;
    private UpdateChecker updateChecker;

    public void onEnable() {
        instance = this;
        this.arenaManager = new ArenaManager();
        this.setupCommandHandler = new SetupCommandHandler();
        this.updateChecker = new UpdateChecker();
        this.updateChecker.check();
        this.events();
        this.commands();
        this.files();
        this.logger.warning("TNT-Tag has been enabled!");
    }

    private void files() {
        try {
            YamlDocument arenasfile;
            Tnttag.arenasfile = arenasfile = YamlDocument.create(new File(this.getDataFolder(), "arenas.yml"), this.getResource("arenas.yml"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            YamlDocument customizationfile;
            Tnttag.customizationfile = customizationfile = YamlDocument.create(new File(this.getDataFolder(), "customization.yml"), this.getResource("customization.yml"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            YamlDocument configfile;
            Tnttag.configfile = configfile = YamlDocument.create(new File(this.getDataFolder(), "config.yml"), this.getResource("config.yml"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            YamlDocument playerdatafile;
            Tnttag.playerdatafile = playerdatafile = YamlDocument.create(new File(this.getDataFolder(), "playerdata.yml"), this.getResource("playerdata.yml"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        new BukkitRunnable(){

            public void run() {
                Tnttag.this.arenaManager.loadArenasFromFile();
            }
        }.runTaskLater((Plugin)this, 20L);
    }

    private void commands() {
        BukkitCommandManager manager = new BukkitCommandManager((Plugin)this);
        manager.registerCommand(new TnttagCommand());
    }

    private void events() {
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerQuitListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new EntityDamageByEntityListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new BlockBreakListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new BlockPlaceListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new AsyncPlayerChatListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.updateChecker, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerInteractListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new InventoryClickListener(), (Plugin)this);
    }

    public void onDisable() {
        this.arenaManager.saveArenasToFile();
        instance = null;
        this.logger.severe("TNT-Tag has been disabled!");
    }

    public static Tnttag getInstance() {
        return instance;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public ArenaManager getArenaManager() {
        return this.arenaManager;
    }

    public static YamlDocument getArenasFile() {
        return arenasfile;
    }

    public SetupCommandHandler getSetupCommandHandler() {
        return this.setupCommandHandler;
    }
}

