/*
 * Decompiled with CFR 0.152.
 */
package ga.juriantech.tnttag;

import ga.juriantech.tnttag.Tnttag;
import ga.juriantech.tnttag.managers.ArenaManager;
import ga.juriantech.tnttag.managers.CountdownManager;
import ga.juriantech.tnttag.utils.ChatUtils;
import ga.juriantech.tnttag.utils.ItemBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;

public class Arena {
    private ArenaManager arenaManager = Tnttag.getInstance().getArenaManager();
    private String name;
    private List<Player> players;
    private List<Player> TNTPlayers = new ArrayList<Player>();
    private List<Player> alivePlayers = new ArrayList<Player>();
    private int maxPlayers;
    private int minPlayers;
    private Location lobbyLocation;
    private Location startLocation;
    private GameState state;
    private HashMap<Player, Location> locations = new HashMap();
    private HashMap<Player, ItemStack[]> inventories = new HashMap();
    private HashMap<Player, ItemStack[]> armor = new HashMap();
    private HashMap<Player, Float> exp = new HashMap();
    private CountdownManager countdownManager;
    private int seconds;
    private int taskID;
    private boolean runningCountdown;
    private ArrayList<String> potionEffects = new ArrayList();

    public Arena(String name, Location startLocation, Location lobbyLocation, int maxPlayers, int minPlayers, ArrayList<String> potionEffects) {
        this.name = name;
        this.players = new ArrayList<Player>();
        this.startLocation = startLocation;
        this.lobbyLocation = lobbyLocation;
        this.state = GameState.STARTING;
        this.maxPlayers = maxPlayers;
        this.minPlayers = minPlayers;
        this.potionEffects = potionEffects;
        this.countdownManager = new CountdownManager(this);
        this.arenaManager.arenaObjects.add(this);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addPlayer(Player player) {
        if (this.state != GameState.INGAME && (this.players.size() != this.maxPlayers || this.players.size() < 6)) {
            this.savePlayerInventory(player);
            this.players.add(player);
            ChatUtils.sendMessage(player, "player.joined-arena");
            ChatUtils.sendArenaMessage(this, player, "arena.player-joined");
            player.teleport(this.lobbyLocation);
            if (this.players.size() != this.minPlayers && this.players.size() < this.minPlayers) {
                player.teleport(this.lobbyLocation);
            } else {
                this.countdownManager.startGame(50);
            }
        }
    }

    public void removePlayer(Player player) {
        for (PotionEffect effect : player.getActivePotionEffects()) {
            player.removePotionEffect(effect.getType());
        }
        this.restorePlayerInventory(player);
        this.players.remove(player);
        ChatUtils.sendMessage(player, "player.leaved-arena");
        ChatUtils.sendArenaMessage(this, player, "arena.player-leaved");
        if (this.runningCountdown && this.players.size() < this.minPlayers) {
            this.setRunningCountdown(false);
            Bukkit.getScheduler().cancelTask(this.taskID);
            ChatUtils.sendArenaMessage(this, player, "arena.countdown-stopped");
        }
    }

    private void savePlayerInventory(Player player) {
        this.locations.put(player, player.getLocation());
        this.inventories.put(player, player.getInventory().getContents());
        this.armor.put(player, player.getInventory().getArmorContents());
        this.exp.put(player, Float.valueOf(player.getExp()));
        player.getInventory().clear();
        player.setExp(0.0f);
        player.getInventory().addItem(new ItemStack[]{new ItemBuilder(Material.BARRIER).displayName(ChatUtils.colorize("&cLeave")).build()});
    }

    private void restorePlayerInventory(Player player) {
        player.getInventory().removeItem(new ItemStack[]{new ItemBuilder(Material.BARRIER).displayName(ChatUtils.colorize("&cLeave")).build()});
        player.getInventory().setContents(this.inventories.get(player));
        player.getInventory().setArmorContents(this.armor.get(player));
        player.setExp(this.exp.get(player).floatValue());
        player.teleport(this.locations.get(player));
        this.inventories.remove(player);
        this.armor.remove(player);
        this.exp.remove(player);
    }

    public void broadcastMessage(String message) {
        for (Player p : this.players) {
            p.sendMessage(ChatUtils.colorize(message));
        }
    }

    public GameState getState() {
        return this.state;
    }

    public void setState(GameState state) {
        this.state = state;
    }

    public List<Player> getPlayers() {
        return this.players;
    }

    public List<Player> getAlivePlayers() {
        return this.alivePlayers;
    }

    public List<Player> getTNTPlayers() {
        return this.TNTPlayers;
    }

    public Location getLobbyLocation() {
        return this.lobbyLocation;
    }

    public int getMaxPlayers() {
        return this.maxPlayers;
    }

    public int getMinPlayers() {
        return this.minPlayers;
    }

    public void setAlivePlayers(List<Player> alivePlayers) {
        this.alivePlayers = alivePlayers;
    }

    public void setTNTPlayers(List<Player> TNTPlayers) {
        this.TNTPlayers = TNTPlayers;
    }

    public Location getStartLocation() {
        return this.startLocation;
    }

    public void setLobbyLocation(Location lobbyLocation) {
        this.lobbyLocation = lobbyLocation;
    }

    public void setStartLocation(Location startLocation) {
        this.startLocation = startLocation;
    }

    public void setMaxPlayers(int maxPlayers) {
        this.maxPlayers = maxPlayers;
    }

    public void setMinPlayers(int minPlayers) {
        this.minPlayers = minPlayers;
    }

    public ArenaManager getArenaManager() {
        return this.arenaManager;
    }

    public int getTaskID() {
        return this.taskID;
    }

    public void setTaskID(int taskID) {
        this.taskID = taskID;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public void setSeconds(int seconds) {
        this.seconds = seconds;
    }

    public boolean isRunningCountdown() {
        return this.runningCountdown;
    }

    public void setRunningCountdown(boolean runningCountdown) {
        this.runningCountdown = runningCountdown;
    }

    public void setPotionEffects(ArrayList<String> potionEffects) {
        this.potionEffects = potionEffects;
    }

    public ArrayList<String> getPotionEffects() {
        return this.potionEffects;
    }

    public static enum GameState {
        INGAME,
        STARTING,
        ENDING;

    }
}

