/*
 * Decompiled with CFR 0.152.
 */
package com.aregcraft.reforging.api.util;

import com.aregcraft.reforging.api.DeltaPlugin;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.RecordComponent;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Classes {
    private Classes() {
    }

    public static <T> Constructor<T> getRecordConstructor(Class<T> type) {
        try {
            return type.getConstructor((Class[])Arrays.stream(type.getRecordComponents()).map(RecordComponent::getType).toArray(Class[]::new));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T newInstance(Constructor<T> constructor, List<Object> args) {
        try {
            return constructor.newInstance(args.toArray());
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T newUncheckedInstance(Constructor<?> constructor, List<Object> args) {
        return (T)Classes.newInstance(constructor, args);
    }

    public static <T> T newInstance(Class<T> type) {
        try {
            return Classes.newInstance(type.getConstructor(new Class[0]), Collections.emptyList());
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T newUncheckedInstance(Class<?> type) {
        return (T)Classes.newInstance(type);
    }

    public static <T> T newInstanceWithPlugin(Class<T> type, DeltaPlugin plugin) {
        T obj = Classes.newInstance(type);
        Classes.setField(obj, "plugin", (Object)plugin);
        return obj;
    }

    public static <T> T newUncheckedInstanceWithPlugin(Class<?> type, DeltaPlugin plugin) {
        return (T)Classes.newInstanceWithPlugin(type, plugin);
    }

    public static void setField(Object obj, String name, Object value) {
        try {
            Field field = obj.getClass().getDeclaredField(name);
            field.setAccessible(true);
            field.set(obj, value);
        }
        catch (NoSuchFieldException field) {
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> Class<T> getClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

