/*
 * Decompiled with CFR 0.152.
 */
package com.aregcraft.reforging.api.scheduler;

import java.util.function.BiConsumer;
import org.bukkit.scheduler.BukkitRunnable;

public interface Scheduler {
    public void scheduleTask(BukkitRunnable var1);

    public void scheduleDelayedTask(BukkitRunnable var1, long var2);

    public void scheduleRepeatingTask(BukkitRunnable var1, long var2, long var4);

    default public void scheduleTask(final Runnable task) {
        this.scheduleTask(new BukkitRunnable(){

            public void run() {
                task.run();
            }
        });
    }

    default public void scheduleDelayedTask(final Runnable task, long delay) {
        this.scheduleDelayedTask(new BukkitRunnable(){

            public void run() {
                task.run();
            }
        }, delay);
    }

    default public void scheduleRepeatingTask(final Runnable task, long delay, long period) {
        this.scheduleRepeatingTask(new BukkitRunnable(){

            public void run() {
                task.run();
            }
        }, delay, period);
    }

    default public void scheduleRepeatingTask(Runnable task, long period) {
        this.scheduleRepeatingTask(task, 0L, period);
    }

    default public void scheduleRepeatingTask(final BiConsumer<BukkitRunnable, Integer> task, long delay, long period) {
        this.scheduleRepeatingTask(new BukkitRunnable(){
            private int i;

            public void run() {
                task.accept(this, this.i++);
            }
        }, delay, period);
    }

    default public void scheduleRepeatingTask(BiConsumer<BukkitRunnable, Integer> task, long period) {
        this.scheduleRepeatingTask(task, 0L, period);
    }

    default public void scheduleRepeatingTask(Runnable task, long delay, long period, long duration) {
        this.scheduleRepeatingTask((BukkitRunnable self, Integer i) -> task.run(), delay, period, duration);
    }

    default public void scheduleRepeatingTask(BiConsumer<BukkitRunnable, Integer> task, long delay, long period, long duration) {
        this.scheduleRepeatingTask((BukkitRunnable self, Integer i) -> {
            if ((long)i.intValue() == duration) {
                self.cancel();
            }
            task.accept((BukkitRunnable)self, (Integer)i);
        }, delay, period);
    }
}

