/*
 * Decompiled with CFR 0.152.
 */
package com.aregcraft.reforging.api.json.adapter;

import com.aregcraft.reforging.api.util.Classes;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.RecordComponent;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class RecordAdapterFactory
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(final Gson gson, final TypeToken<T> type) {
        final Class rawType = type.getRawType();
        if (!rawType.isRecord()) {
            return null;
        }
        return new TypeAdapter<T>(){

            public void write(JsonWriter out, T value) throws IOException {
                gson.getDelegateAdapter((TypeAdapterFactory)RecordAdapterFactory.this, type).write(out, value);
            }

            public T read(JsonReader in) throws IOException {
                if (in.peek() == JsonToken.NULL) {
                    in.nextNull();
                    return null;
                }
                RecordComponent[] components = rawType.getRecordComponents();
                List<String> names = Arrays.stream(components).map(RecordComponent::getName).toList();
                Map<String, Type> types = Arrays.stream(components).collect(Collectors.toMap(RecordComponent::getName, RecordComponent::getGenericType));
                List<Object> values = Arrays.asList(new Object[names.size()]);
                in.beginObject();
                while (in.hasNext()) {
                    String name = in.nextName();
                    values.set(names.indexOf(name), gson.getAdapter(TypeToken.get((Type)types.get(name))).read(in));
                }
                in.endObject();
                return Classes.newInstance(Classes.getRecordConstructor(rawType), values);
            }
        };
    }
}

